"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationCount = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _level_info_tip = require("./level_info_tip");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  getCriticalStatusLabel: count => _i18n.i18n.translate('xpack.upgradeAssistant.deprecationCount.criticalStatusLabel', {
    defaultMessage: 'Critical: {count}',
    values: {
      count
    }
  }),
  getWarningStatusLabel: count => _i18n.i18n.translate('xpack.upgradeAssistant.deprecationCount.warningStatusLabel', {
    defaultMessage: 'Warning: {count}',
    values: {
      count
    }
  })
};
const DeprecationCount = ({
  totalCriticalDeprecations,
  totalWarningDeprecations
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger",
    "data-test-subj": "criticalDeprecationsCount"
  }, i18nTexts.getCriticalStatusLabel(totalCriticalDeprecations))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_level_info_tip.LevelInfoTip, {
    level: "critical"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued",
    "data-test-subj": "warningDeprecationsCount"
  }, i18nTexts.getWarningStatusLabel(totalWarningDeprecations))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_level_info_tip.LevelInfoTip, {
    level: "warning"
  })))));
};
exports.DeprecationCount = DeprecationCount;