"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaDeprecationsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _resolution_table_cell = require("./resolution_table_cell");
var _shared = require("../shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  refreshButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.refreshButtonLabel', {
    defaultMessage: 'Refresh'
  }),
  statusColumnTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.statusColumnTitle', {
    defaultMessage: 'Status'
  }),
  issueColumnTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.issueColumnTitle', {
    defaultMessage: 'Issue'
  }),
  typeColumnTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.typeColumnTitle', {
    defaultMessage: 'Type'
  }),
  resolutionColumnTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.resolutionColumnTitle', {
    defaultMessage: 'Resolution'
  }),
  configDeprecationTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.configDeprecationTypeCellLabel', {
    defaultMessage: 'Config'
  }),
  featureDeprecationTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.featureDeprecationTypeCellLabel', {
    defaultMessage: 'Feature'
  }),
  unknownDeprecationTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.unknownDeprecationTypeCellLabel', {
    defaultMessage: 'Uncategorized'
  }),
  typeFilterLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.typeFilterLabel', {
    defaultMessage: 'Type'
  }),
  criticalFilterLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.criticalFilterLabel', {
    defaultMessage: 'Critical'
  }),
  searchPlaceholderLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.searchPlaceholderLabel', {
    defaultMessage: 'Filter'
  })
};
const KibanaDeprecationsTable = ({
  deprecations,
  reload,
  toggleFlyout,
  deprecationResolutionState
}) => {
  const columns = [{
    field: 'level',
    name: i18nTexts.statusColumnTitle,
    width: '5%',
    truncateText: true,
    sortable: true,
    render: level => {
      return /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
        isCritical: level === 'critical'
      });
    }
  }, {
    field: 'title',
    width: '40%',
    name: i18nTexts.issueColumnTitle,
    truncateText: true,
    sortable: true,
    render: (title, deprecation) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => toggleFlyout(deprecation),
        "data-test-subj": "deprecationDetailsLink"
      }, title);
    }
  }, {
    field: 'filterType',
    name: i18nTexts.typeColumnTitle,
    width: '20%',
    truncateText: true,
    sortable: true,
    render: filterType => {
      switch (filterType) {
        case 'config':
          return i18nTexts.configDeprecationTypeCellLabel;
        case 'feature':
          return i18nTexts.featureDeprecationTypeCellLabel;
        case 'uncategorized':
        default:
          return i18nTexts.unknownDeprecationTypeCellLabel;
      }
    }
  }, {
    field: 'correctiveActions',
    name: i18nTexts.resolutionColumnTitle,
    width: '30%',
    truncateText: true,
    sortable: true,
    render: (correctiveActions, deprecation) => {
      return /*#__PURE__*/_react.default.createElement(_resolution_table_cell.ResolutionTableCell, {
        deprecationId: deprecation.id,
        isAutomated: Boolean(correctiveActions === null || correctiveActions === void 0 ? void 0 : correctiveActions.api),
        deprecationResolutionState: deprecationResolutionState
      });
    }
  }];
  const sorting = {
    sort: {
      field: 'level',
      direction: 'asc'
    }
  };
  const searchConfig = {
    filters: [{
      type: 'field_value_toggle',
      name: i18nTexts.criticalFilterLabel,
      field: 'level',
      value: 'critical'
    }, {
      type: 'field_value_selection',
      field: 'filterType',
      name: i18nTexts.typeFilterLabel,
      multiSelect: false,
      options: [{
        value: 'config',
        name: i18nTexts.configDeprecationTypeCellLabel
      }, {
        value: 'feature',
        name: i18nTexts.featureDeprecationTypeCellLabel
      }, {
        value: 'uncategorized',
        name: i18nTexts.unknownDeprecationTypeCellLabel
      }]
    }],
    box: {
      incremental: true,
      placeholder: i18nTexts.searchPlaceholderLabel
    },
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "refresh",
      onClick: reload,
      "data-test-subj": "refreshButton",
      key: "refreshButton"
    }, i18nTexts.refreshButtonLabel)]
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: deprecations || [],
    itemId: "name",
    columns: columns,
    search: searchConfig,
    sorting: sorting,
    pagination: _constants.PAGINATION_CONFIG,
    rowProps: () => ({
      'data-test-subj': 'row'
    }),
    cellProps: (deprecation, field) => ({
      'data-test-subj': `${((field === null || field === void 0 ? void 0 : field.name) || 'table').toLowerCase()}Cell`
    }),
    "data-test-subj": "kibanaDeprecationsTable",
    tableLayout: "auto"
  });
};
exports.KibanaDeprecationsTable = KibanaDeprecationsTable;