"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimefilter = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useTimefilter = props => {
  const initialTimeRange = {
    from: props.dateRangeFrom || props.timefilter.getTime().from,
    to: props.dateRangeTo || props.timefilter.getTime().to
  };
  const initialRefreshInterval = {
    value: props.refreshInterval || props.timefilter.getRefreshInterval().value,
    pause: props.isRefreshPaused || props.timefilter.getRefreshInterval().pause
  };
  const [timeRange, setTimerange] = (0, _react.useState)(initialTimeRange);
  const [refreshInterval, setRefreshInterval] = (0, _react.useState)(initialRefreshInterval);
  (0, _react.useEffect)(() => {
    const subscriptions = new _rxjs.Subscription();
    subscriptions.add(props.timefilter.getRefreshIntervalUpdate$().subscribe({
      next: () => {
        const newRefreshInterval = props.timefilter.getRefreshInterval();
        setRefreshInterval(newRefreshInterval);
      }
    }));
    subscriptions.add(props.timefilter.getTimeUpdate$().subscribe({
      next: () => {
        setTimerange(props.timefilter.getTime());
      }
    }));
    return () => {
      subscriptions.unsubscribe();
    };
  }, [props.timefilter]);
  return {
    refreshInterval,
    timeRange
  };
};
exports.useTimefilter = useTimefilter;