"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResizableButton = ResizableButton;
var _react = _interopRequireDefault(require("react"));
require("./resizable_button.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ResizableButton({
  onMouseDownResizeHandler,
  onKeyDownResizeHandler
}) {
  const setFocus = e => e.currentTarget.focus();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "unifiedTextLangEditor--resizableButtonContainer"
  }, /*#__PURE__*/_react.default.createElement("button", {
    "data-test-subj": "unifiedTextLangEditor-resize",
    className: "unifiedTextLangEditor--resizableButton",
    onMouseDown: onMouseDownResizeHandler,
    onKeyDown: onKeyDownResizeHandler,
    onClick: setFocus
  }));
}