"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextBasedLanguagesEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _classnames = _interopRequireDefault(require("classnames"));
var _monaco = require("@kbn/monaco");
var _esQuery = require("@kbn/es-query");
var _languageDocumentationPopover = require("@kbn/language-documentation-popover");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _text_based_languages_editor = require("./text_based_languages_editor.styles");
var _helpers = require("./helpers");
var _editor_footer = require("./editor_footer");
var _resizable_button = require("./resizable_button");
require("./overwrite.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MAX_COMPACT_VIEW_LENGTH = 250;
const FONT_WIDTH = 8;
const EDITOR_ONE_LINER_UNUSED_SPACE = 180;
const EDITOR_ONE_LINER_UNUSED_SPACE_WITH_ERRORS = 220;
const KEYCODE_ARROW_UP = 38;
const KEYCODE_ARROW_DOWN = 40;
const languageId = language => {
  switch (language) {
    case 'sql':
    default:
      {
        return _monaco.SQLLang.ID;
      }
  }
};
let clickedOutside = false;
let initialRender = true;
let updateLinesFromModel = false;
const TextBasedLanguagesEditor = /*#__PURE__*/(0, _react.memo)(function TextBasedLanguagesEditor({
  query,
  onTextLangQueryChange,
  onTextLangQuerySubmit,
  expandCodeEditor,
  isCodeEditorExpanded,
  errors,
  isDisabled
}) {
  var _query$language;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const language = (0, _esQuery.getAggregateQueryMode)(query);
  const queryString = (_query$language = query[language]) !== null && _query$language !== void 0 ? _query$language : '';
  const [lines, setLines] = (0, _react.useState)(1);
  const [code, setCode] = (0, _react.useState)(queryString !== null && queryString !== void 0 ? queryString : '');
  const [codeOneLiner, setCodeOneLiner] = (0, _react.useState)('');
  const [editorHeight, setEditorHeight] = (0, _react.useState)(isCodeEditorExpanded ? _text_based_languages_editor.EDITOR_INITIAL_HEIGHT_EXPANDED : _text_based_languages_editor.EDITOR_INITIAL_HEIGHT);
  const [showLineNumbers, setShowLineNumbers] = (0, _react.useState)(isCodeEditorExpanded);
  const [isCompactFocused, setIsCompactFocused] = (0, _react.useState)(isCodeEditorExpanded);
  const [isCodeEditorExpandedFocused, setIsCodeEditorExpandedFocused] = (0, _react.useState)(false);
  const [isWordWrapped, setIsWordWrapped] = (0, _react.useState)(true);
  const [editorErrors, setEditorErrors] = (0, _react.useState)([]);
  const [documentationSections, setDocumentationSections] = (0, _react.useState)();
  const kibana = (0, _public.useKibana)();
  const {
    theme
  } = kibana.services;
  const styles = (0, _text_based_languages_editor.textBasedLanguagedEditorStyles)(euiTheme, isCompactFocused, editorHeight, isCodeEditorExpanded, Boolean(errors === null || errors === void 0 ? void 0 : errors.length), isCodeEditorExpandedFocused);
  const isDark = (0, _useObservable.default)(theme.theme$, {
    darkMode: false
  }).darkMode;
  const editorModel = (0, _react.useRef)();
  const editor1 = (0, _react.useRef)();
  const containerRef = (0, _react.useRef)(null);
  const editorClassName = (0, _classnames.default)('unifiedTextLangEditor', {
    'unifiedTextLangEditor--expanded': isCodeEditorExpanded,
    'unifiedTextLangEditor--compact': isCompactFocused,
    'unifiedTextLangEditor--initial': !isCompactFocused
  });

  // When the editor is on full size mode, the user can resize the height of the editor.
  const onMouseDownResizeHandler = (0, _react.useCallback)(mouseDownEvent => {
    const startSize = editorHeight;
    const startPosition = mouseDownEvent.pageY;
    function onMouseMove(mouseMoveEvent) {
      const height = startSize - startPosition + mouseMoveEvent.pageY;
      const validatedHeight = Math.min(Math.max(height, _text_based_languages_editor.EDITOR_MIN_HEIGHT), _text_based_languages_editor.EDITOR_MAX_HEIGHT);
      setEditorHeight(validatedHeight);
    }
    function onMouseUp() {
      document.body.removeEventListener('mousemove', onMouseMove);
    }
    document.body.addEventListener('mousemove', onMouseMove);
    document.body.addEventListener('mouseup', onMouseUp, {
      once: true
    });
  }, [editorHeight]);
  const onKeyDownResizeHandler = (0, _react.useCallback)(keyDownEvent => {
    let height = editorHeight;
    if (keyDownEvent.keyCode === KEYCODE_ARROW_UP || keyDownEvent.keyCode === KEYCODE_ARROW_DOWN) {
      const step = keyDownEvent.keyCode === KEYCODE_ARROW_UP ? -10 : 10;
      height = height + step;
      const validatedHeight = Math.min(Math.max(height, _text_based_languages_editor.EDITOR_MIN_HEIGHT), _text_based_languages_editor.EDITOR_MAX_HEIGHT);
      setEditorHeight(validatedHeight);
    }
  }, [editorHeight]);
  const updateHeight = () => {
    if (editor1.current) {
      var _editorModel$current;
      const linesCount = ((_editorModel$current = editorModel.current) === null || _editorModel$current === void 0 ? void 0 : _editorModel$current.getLineCount()) || 1;
      if (linesCount === 1 || clickedOutside || initialRender) return;
      const editorElement = editor1.current.getDomNode();
      const contentHeight = Math.min(MAX_COMPACT_VIEW_LENGTH, editor1.current.getContentHeight());
      if (editorElement) {
        editorElement.style.height = `${contentHeight}px`;
      }
      const contentWidth = Number(editorElement === null || editorElement === void 0 ? void 0 : editorElement.style.width.replace('px', ''));
      editor1.current.layout({
        width: contentWidth,
        height: contentHeight
      });
      setEditorHeight(contentHeight);
    }
  };
  const restoreInitialMode = () => {
    setIsCodeEditorExpandedFocused(false);
    if (isCodeEditorExpanded) return;
    setEditorHeight(_text_based_languages_editor.EDITOR_INITIAL_HEIGHT);
    setIsCompactFocused(false);
    setShowLineNumbers(false);
    updateLinesFromModel = false;
    clickedOutside = true;
    if (editor1.current) {
      const editorElement = editor1.current.getDomNode();
      if (editorElement) {
        editorElement.style.height = `${_text_based_languages_editor.EDITOR_INITIAL_HEIGHT}px`;
        const contentWidth = Number(editorElement === null || editorElement === void 0 ? void 0 : editorElement.style.width.replace('px', ''));
        calculateVisibleCode(contentWidth, true);
        editor1.current.layout({
          width: contentWidth,
          height: _text_based_languages_editor.EDITOR_INITIAL_HEIGHT
        });
      }
    }
  };
  (0, _helpers.useDebounceWithOptions)(() => {
    var _editor1$current, _editor1$current2, _editor1$current3;
    if (!editorModel.current) return;
    (_editor1$current = editor1.current) === null || _editor1$current === void 0 ? void 0 : _editor1$current.onDidChangeModelContent(e => {
      if (updateLinesFromModel) {
        var _editorModel$current2;
        setLines(((_editorModel$current2 = editorModel.current) === null || _editorModel$current2 === void 0 ? void 0 : _editorModel$current2.getLineCount()) || 1);
      }
    });
    (_editor1$current2 = editor1.current) === null || _editor1$current2 === void 0 ? void 0 : _editor1$current2.onDidFocusEditorText(() => {
      setIsCompactFocused(true);
      setIsCodeEditorExpandedFocused(true);
      setShowLineNumbers(true);
      setCodeOneLiner('');
      clickedOutside = false;
      initialRender = false;
      updateLinesFromModel = true;
    });
    // on CMD/CTRL + Enter submit the query
    // eslint-disable-next-line no-bitwise
    (_editor1$current3 = editor1.current) === null || _editor1$current3 === void 0 ? void 0 : _editor1$current3.addCommand(_monaco.monaco.KeyMod.CtrlCmd | _monaco.monaco.KeyCode.Enter, function () {
      onTextLangQuerySubmit();
    });
    if (!isCodeEditorExpanded) {
      var _editor1$current4;
      (_editor1$current4 = editor1.current) === null || _editor1$current4 === void 0 ? void 0 : _editor1$current4.onDidContentSizeChange(updateHeight);
    }
    if (errors && errors.length) {
      const parsedErrors = (0, _helpers.parseErrors)(errors, code);
      setEditorErrors(parsedErrors);
      _monaco.monaco.editor.setModelMarkers(editorModel.current, 'Unified search', parsedErrors);
    } else {
      _monaco.monaco.editor.setModelMarkers(editorModel.current, 'Unified search', []);
      setEditorErrors([]);
    }
  }, {
    skipFirstRender: false
  }, 256, [errors]);
  const onErrorClick = (0, _react.useCallback)(({
    startLineNumber,
    startColumn
  }) => {
    if (!editor1.current) {
      return;
    }
    editor1.current.focus();
    editor1.current.setPosition({
      lineNumber: startLineNumber,
      column: startColumn
    });
    editor1.current.revealLine(startLineNumber);
  }, []);

  // Clean up the monaco editor and DOM on unmount
  (0, _react.useEffect)(() => {
    const model = editorModel;
    const editor1ref = editor1;
    return () => {
      var _model$current, _editor1ref$current;
      (_model$current = model.current) === null || _model$current === void 0 ? void 0 : _model$current.dispose();
      (_editor1ref$current = editor1ref.current) === null || _editor1ref$current === void 0 ? void 0 : _editor1ref$current.dispose();
    };
  }, []);
  const calculateVisibleCode = (0, _react.useCallback)((width, force) => {
    var _containerRef$current;
    const containerWidth = (_containerRef$current = containerRef.current) === null || _containerRef$current === void 0 ? void 0 : _containerRef$current.offsetWidth;
    if (containerWidth && (!isCompactFocused || force)) {
      const hasLines = /\r|\n/.exec(queryString);
      if (hasLines && !updateLinesFromModel) {
        setLines(queryString.split(/\r|\n/).length);
      }
      const text = (0, _helpers.getInlineEditorText)(queryString, Boolean(hasLines));
      const queryLength = text.length;
      const unusedSpace = errors && errors.length ? EDITOR_ONE_LINER_UNUSED_SPACE_WITH_ERRORS : EDITOR_ONE_LINER_UNUSED_SPACE;
      const charactersAlowed = Math.floor((width - unusedSpace) / FONT_WIDTH);
      if (queryLength > charactersAlowed) {
        const shortedCode = text.substring(0, charactersAlowed) + '...';
        setCodeOneLiner(shortedCode);
      } else {
        const shortedCode = text;
        setCodeOneLiner(shortedCode);
      }
    }
  }, [queryString, errors, isCompactFocused]);
  (0, _react.useEffect)(() => {
    if (editor1.current && !isCompactFocused) {
      const editorElement = editor1.current.getDomNode();
      if (editorElement) {
        const contentWidth = Number(editorElement === null || editorElement === void 0 ? void 0 : editorElement.style.width.replace('px', ''));
        if (code !== queryString) {
          setCode(queryString);
          calculateVisibleCode(contentWidth);
        }
      }
    }
  }, [calculateVisibleCode, code, isCompactFocused, queryString]);
  const onResize = ({
    width
  }) => {
    calculateVisibleCode(width);
    if (editor1.current) {
      editor1.current.layout({
        width,
        height: editorHeight
      });
    }
  };
  const onQueryUpdate = (0, _react.useCallback)(value => {
    setCode(value);
    onTextLangQueryChange({
      [language]: value
    });
  }, [language, onTextLangQueryChange]);
  (0, _react.useEffect)(() => {
    async function getDocumentation() {
      const sections = await (0, _helpers.getDocumentationSections)(language);
      setDocumentationSections(sections);
    }
    getDocumentation();
  }, [language]);
  const codeEditorOptions = {
    automaticLayout: false,
    accessibilitySupport: 'off',
    folding: false,
    fontSize: 14,
    padding: {
      top: 8,
      bottom: 8
    },
    scrollBeyondLastLine: false,
    quickSuggestions: true,
    minimap: {
      enabled: false
    },
    wordWrap: isWordWrapped ? 'on' : 'off',
    lineNumbers: showLineNumbers ? 'on' : 'off',
    theme: isDark ? 'vs-dark' : 'vs',
    lineDecorationsWidth: 12,
    autoIndent: 'none',
    wrappingIndent: 'none',
    lineNumbersMinChars: 3,
    overviewRulerLanes: 0,
    hideCursorInOverviewRuler: true,
    scrollbar: {
      horizontal: 'hidden',
      vertical: 'auto'
    },
    overviewRulerBorder: false,
    readOnly: isDisabled
  };
  if (isCompactFocused) {
    codeEditorOptions.overviewRulerLanes = 4;
    codeEditorOptions.hideCursorInOverviewRuler = false;
    codeEditorOptions.overviewRulerBorder = true;
  }
  const editorPanel = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isCodeEditorExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    css: styles.topContainer,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: isWordWrapped ? _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.disableWordWrapLabel', {
      defaultMessage: 'Disable word wrap'
    }) : _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.EnableWordWrapLabel', {
      defaultMessage: 'Enable word wrap'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isWordWrapped ? 'wordWrap' : 'wordWrapDisabled',
    color: "text",
    "data-test-subj": "unifiedTextLangEditor-toggleWordWrap",
    "aria-label": isWordWrapped ? _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.disableWordWrapLabel', {
      defaultMessage: 'Disable word wrap'
    }) : _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.EnableWordWrapLabel', {
      defaultMessage: 'Enable word wrap'
    }),
    isSelected: !isWordWrapped,
    onClick: () => {
      var _editor1$current5;
      (_editor1$current5 = editor1.current) === null || _editor1$current5 === void 0 ? void 0 : _editor1$current5.updateOptions({
        wordWrap: isWordWrapped ? 'off' : 'on'
      });
      setIsWordWrapped(!isWordWrapped);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginRight: '8px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.minimizeTooltip', {
      defaultMessage: 'Compact query editor'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "minimize",
    color: "text",
    "aria-label": _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.MinimizeEditor', {
      defaultMessage: 'Minimize editor'
    }),
    "data-test-subj": "unifiedTextLangEditor-minimize",
    onClick: () => {
      expandCodeEditor(false);
      updateLinesFromModel = false;
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_languageDocumentationPopover.LanguageDocumentationPopover, {
    language: String(language).toUpperCase(),
    sections: documentationSections,
    buttonProps: {
      color: 'text',
      'data-test-subj': 'unifiedTextLangEditor-documentation',
      'aria-label': _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.documentationLabel', {
        defaultMessage: 'Documentation'
      })
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    css: {
      margin: '0 0 1px 0'
    },
    ref: containerRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: onResize
  }, resizeRef => /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: () => {
      restoreInitialMode();
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef,
    css: styles.resizableContainer
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "unifiedTextLangEditor",
    className: editorClassName
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.editorContainer
  }, !isCompactFocused && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: euiTheme.colors.lightShade,
    css: styles.linesBadge,
    "data-test-subj": "unifiedTextLangEditor-inline-lines-badge"
  }, _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.lineCount', {
    defaultMessage: '{count} {count, plural, one {line} other {lines}}',
    values: {
      count: lines
    }
  })), !isCompactFocused && errors && errors.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: euiTheme.colors.danger,
    css: styles.errorsBadge,
    iconType: "error",
    iconSide: "left",
    "data-test-subj": "unifiedTextLangEditor-inline-errors-badge"
  }, errors.length), /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    languageId: languageId(language),
    value: codeOneLiner || code,
    options: codeEditorOptions,
    width: "100%",
    onChange: onQueryUpdate,
    editorDidMount: editor => {
      editor1.current = editor;
      const model = editor.getModel();
      if (model) {
        editorModel.current = model;
      }
      if (isCodeEditorExpanded) {
        setLines((model === null || model === void 0 ? void 0 : model.getLineCount()) || 1);
      }
    }
  }), isCompactFocused && !isCodeEditorExpanded && /*#__PURE__*/_react.default.createElement(_editor_footer.EditorFooter, {
    lines: lines,
    containerCSS: styles.bottomContainer,
    errors: editorErrors,
    onErrorClick: onErrorClick,
    refreshErrors: onTextLangQuerySubmit
  })))))), !isCodeEditorExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.expandTooltip', {
      defaultMessage: 'Expand query editor'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "empty",
    iconType: "expand",
    size: "m",
    "aria-label": "Expand",
    onClick: () => expandCodeEditor(true),
    "data-test-subj": "unifiedTextLangEditor-expand",
    css: {
      borderRadius: 0,
      backgroundColor: isDark ? euiTheme.colors.lightestShade : '#e9edf3',
      border: '1px solid rgb(17 43 134 / 10%) !important'
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_languageDocumentationPopover.LanguageDocumentationPopover, {
    language: String(language).toUpperCase(),
    sections: documentationSections,
    buttonProps: {
      display: 'empty',
      'data-test-subj': 'unifiedTextLangEditor-inline-documentation',
      'aria-label': _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.documentationLabel', {
        defaultMessage: 'Documentation'
      }),
      size: 'm',
      css: {
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        backgroundColor: isDark ? euiTheme.colors.lightestShade : '#e9edf3',
        border: '1px solid rgb(17 43 134 / 10%) !important',
        borderLeft: 'transparent !important'
      }
    }
  }))))), isCodeEditorExpanded && /*#__PURE__*/_react.default.createElement(_editor_footer.EditorFooter, {
    lines: lines,
    containerCSS: styles.bottomContainer,
    errors: editorErrors,
    onErrorClick: onErrorClick,
    refreshErrors: onTextLangQuerySubmit
  }), isCodeEditorExpanded && /*#__PURE__*/_react.default.createElement(_resizable_button.ResizableButton, {
    onMouseDownResizeHandler: onMouseDownResizeHandler,
    onKeyDownResizeHandler: onKeyDownResizeHandler
  }));
  return editorPanel;
});
exports.TextBasedLanguagesEditor = TextBasedLanguagesEditor;