"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDebounceWithOptions = exports.parseErrors = exports.getInlineEditorText = exports.getDocumentationSections = void 0;
var _react = require("react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _monaco = require("@kbn/monaco");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const useDebounceWithOptions = (fn, {
  skipFirstRender
} = {
  skipFirstRender: false
}, ms, deps) => {
  const isFirstRender = (0, _react.useRef)(true);
  const newDeps = [...(deps || []), isFirstRender];
  return (0, _useDebounce.default)(() => {
    if (skipFirstRender && isFirstRender.current) {
      isFirstRender.current = false;
      return;
    }
    return fn();
  }, ms, newDeps);
};
exports.useDebounceWithOptions = useDebounceWithOptions;
const parseErrors = (errors, code) => {
  return errors.map(error => {
    if (error.message.includes('line')) {
      const text = error.message.split('line')[1];
      const [lineNumber, startPosition, errorMessage] = text.split(':');
      // initialize the length to 10 in case no error word found
      let errorLength = 10;
      const [_, wordWithError] = errorMessage.split('[');
      if (wordWithError) {
        errorLength = wordWithError.length - 1;
      }
      return {
        message: errorMessage,
        startColumn: Number(startPosition),
        startLineNumber: Number(lineNumber),
        endColumn: Number(startPosition) + errorLength,
        endLineNumber: Number(lineNumber),
        severity: _monaco.monaco.MarkerSeverity.Error
      };
    } else {
      // unknown error message
      return {
        message: error.message,
        startColumn: 1,
        startLineNumber: 1,
        endColumn: 10,
        endLineNumber: 1,
        severity: _monaco.monaco.MarkerSeverity.Error
      };
    }
  });
};
exports.parseErrors = parseErrors;
const getDocumentationSections = async language => {
  const groups = [];
  if (language === 'sql') {
    const {
      comparisonOperators,
      logicalOperators,
      mathOperators,
      initialSection,
      aggregateFunctions
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./sql_documentation_sections')));
    groups.push({
      label: _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.howItWorks', {
        defaultMessage: 'How it works'
      }),
      items: []
    });
    groups.push(comparisonOperators, logicalOperators, mathOperators, aggregateFunctions);
    return {
      groups,
      initialSection
    };
  }
};
exports.getDocumentationSections = getDocumentationSections;
const getInlineEditorText = (queryString, isMultiLine) => {
  return isMultiLine ? queryString.replace(/\r?\n|\r/g, ' ').replace(/  +/g, ' ') : queryString;
};
exports.getInlineEditorText = getInlineEditorText;