"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _css = require("@emotion/css");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isMac = navigator.platform.toLowerCase().indexOf('mac') >= 0;
const COMMAND_KEY = isMac ? '⌘' : '^';
const EditorFooter = /*#__PURE__*/(0, _react.memo)(function EditorFooter({
  lines,
  containerCSS,
  errors,
  onErrorClick,
  refreshErrors
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    "data-test-subj": "unifiedTextLangEditor-footer",
    css: containerCSS,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginRight: '16px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    "data-test-subj": "unifiedTextLangEditor-footer-lines"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.lineCount', {
    defaultMessage: '{count} {count, plural, one {line} other {lines}}',
    values: {
      count: lines
    }
  })))), errors && errors.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "error",
    color: "danger",
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "danger",
      css: (0, _react2.css)`
                          &:hover {
                            cursor: pointer;
                            text-decoration: underline;
                          }
                        `,
      onClick: () => {
        refreshErrors();
        setIsPopoverOpen(!isPopoverOpen);
      }
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.errorCount', {
      defaultMessage: '{count} {count, plural, one {error} other {errors}}',
      values: {
        count: errors.length
      }
    }))),
    ownFocus: false,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 500
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.errorsTitle', {
    defaultMessage: 'Errors'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, errors.map((error, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      key: index,
      className: (0, _css.css)`
                                &:hover {
                                  cursor: pointer;
                                }
                              `,
      onClick: () => onErrorClick(error)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xl",
      alignItems: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "error",
      color: "danger",
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        whiteSpace: 'nowrap'
      }
    }, _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.lineNumber', {
      defaultMessage: 'Line {lineNumber}',
      values: {
        lineNumber: error.startLineNumber
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "unifiedTextLangEditor_errorMessage"
    }, error.message)));
  }))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('unifiedSearch.query.textBasedLanguagesEditor.runQuery', {
    defaultMessage: 'Run query'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    transparentBackground: true,
    css: (0, _react2.css)`
                font-size: 12px;
              `
  }, `${COMMAND_KEY} + Enter`)))));
});
exports.EditorFooter = EditorFooter;