"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromUser = fromUser;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Take userInput from the user and make it into a query object
 * @returns {object}
 * @param userInput
 */

function fromUser(userInput) {
  const matchAll = '';
  if (_lodash.default.isEmpty(userInput)) {
    return '';
  }
  if (_lodash.default.isObject(userInput)) {
    return userInput;
  }
  userInput = userInput || '';
  if (typeof userInput === 'string') {
    const trimmedUserInput = userInput.trim();
    if (trimmedUserInput.length === 0) {
      return matchAll;
    }
    if (trimmedUserInput[0] === '{') {
      try {
        return JSON.parse(trimmedUserInput);
      } catch (e) {
        return userInput;
      }
    } else {
      return userInput;
    }
  }
}