"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
class IndexPatternSelect extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isMounted", false);
    (0, _defineProperty2.default)(this, "state", void 0);
    (0, _defineProperty2.default)(this, "fetchSelectedIndexPattern", async indexPatternId => {
      if (!indexPatternId) {
        this.setState({
          selectedIndexPattern: undefined
        });
        return;
      }
      let label;
      try {
        const indexPattern = await this.props.indexPatternService.get(indexPatternId);
        label = indexPattern.getName();
      } catch (err) {
        // index pattern no longer exists
        return;
      }
      if (!this.isMounted) {
        return;
      }
      this.setState({
        selectedIndexPattern: {
          value: indexPatternId,
          label
        }
      });
    });
    (0, _defineProperty2.default)(this, "debouncedFetch", _lodash.default.debounce(async searchValue => {
      const dataViews = await this.props.indexPatternService.getIdsWithTitle();
      if (!this.isMounted || searchValue !== this.state.searchValue) {
        return;
      }
      const options = [];
      for (let i = 0; i < dataViews.length; i++) {
        const label = dataViews[i].name ? dataViews[i].name : dataViews[i].title;
        if (label && label.toLowerCase().includes(searchValue.toLowerCase())) {
          options.push({
            label,
            value: dataViews[i].id
          });
        }
      }
      this.setState({
        isLoading: false,
        options
      });
      if (this.props.onNoIndexPatterns && searchValue === '' && options.length === 0) {
        this.props.onNoIndexPatterns();
      }
    }, 300));
    (0, _defineProperty2.default)(this, "fetchOptions", (searchValue = '') => {
      this.setState({
        isLoading: true,
        searchValue
      }, this.debouncedFetch.bind(null, searchValue));
    });
    (0, _defineProperty2.default)(this, "onChange", selectedOptions => {
      this.props.onChange(_lodash.default.get(selectedOptions, '0.value'));
    });
    this.state = {
      isLoading: false,
      options: [],
      selectedIndexPattern: undefined,
      searchValue: undefined
    };
  }
  componentWillUnmount() {
    this.isMounted = false;
    this.debouncedFetch.cancel();
  }
  componentDidMount() {
    this.isMounted = true;
    this.fetchOptions('');
    this.fetchSelectedIndexPattern(this.props.indexPatternId);
  }
  UNSAFE_componentWillReceiveProps(nextProps) {
    if (nextProps.indexPatternId !== this.props.indexPatternId) {
      this.fetchSelectedIndexPattern(nextProps.indexPatternId);
    }
  }
  render() {
    const {
      onChange,
      indexPatternId,
      placeholder,
      onNoIndexPatterns,
      indexPatternService,
      ...rest
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, rest, {
      placeholder: placeholder,
      singleSelection: true,
      isLoading: this.state.isLoading,
      onSearchChange: this.fetchOptions,
      options: this.state.options,
      selectedOptions: this.state.selectedIndexPattern ? [this.state.selectedIndexPattern] : [],
      onChange: this.onChange
    }));
  }
}
exports.default = IndexPatternSelect;
module.exports = exports.default;