"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParamsEditor = ParamsEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../../filter_bar/filter_editor/lib");
var _context = require("../context");
var _params_editor_input = require("./params_editor_input");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ParamsEditor({
  dataView,
  field,
  operator,
  params,
  onHandleParamsChange,
  onHandleParamsUpdate,
  timeRangeForSuggestionsOverride,
  filtersForSuggestions
}) {
  const {
    disabled
  } = (0, _react.useContext)(_context.FiltersBuilderContextType);
  const onParamsChange = (0, _react.useCallback)(selectedParams => {
    onHandleParamsChange(selectedParams);
  }, [onHandleParamsChange]);
  const onParamsUpdate = (0, _react.useCallback)(value => {
    onHandleParamsUpdate(value);
  }, [onHandleParamsUpdate]);
  const {
    isInvalid,
    errorMessage
  } = (0, _lib.getFieldValidityAndErrorMessage)(field, typeof params === 'string' ? params : undefined);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: isInvalid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: errorMessage !== null && errorMessage !== void 0 ? errorMessage : null,
    display: "block"
  }, /*#__PURE__*/_react.default.createElement(_params_editor_input.ParamsEditorInput, {
    field: field,
    params: params,
    operator: operator,
    invalid: isInvalid,
    disabled: disabled,
    dataView: dataView,
    onParamsChange: onParamsChange,
    onParamsUpdate: onParamsUpdate,
    timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
    filtersForSuggestions: filtersForSuggestions
  })));
}