"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.operationCss = exports.getGrabIconCss = exports.fieldAndParamCss = exports.disabledDraggableCss = exports.cursorOrCss = exports.cursorAddCss = exports.actionButtonCss = void 0;
var _css = require("@emotion/css");
var _add = _interopRequireDefault(require("../assets/add.svg"));
var _or = _interopRequireDefault(require("../assets/or.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const cursorAddCss = (0, _css.css)`
  cursor: url(${_add.default}), auto;
`;
exports.cursorAddCss = cursorAddCss;
const cursorOrCss = (0, _css.css)`
  cursor: url(${_or.default}), auto;
`;
exports.cursorOrCss = cursorOrCss;
const fieldAndParamCss = euiTheme => (0, _css.css)`
  min-width: calc(${euiTheme.size.xl} * 5);
`;
exports.fieldAndParamCss = fieldAndParamCss;
const operationCss = euiTheme => (0, _css.css)`
  max-width: calc(${euiTheme.size.xl} * 4.5);
  // temporary fix to be removed after https://github.com/elastic/eui/issues/2082 is fixed
  .euiComboBox__inputWrap {
    padding-right: calc(${euiTheme.size.base}) !important;
  }
`;
exports.operationCss = operationCss;
const getGrabIconCss = euiTheme => (0, _css.css)`
  margin: 0 ${euiTheme.size.xxs};
`;
exports.getGrabIconCss = getGrabIconCss;
const actionButtonCss = (0, _css.css)`
  &.euiButtonEmpty .euiButtonEmpty__content {
    padding: 0 4px;
  }
`;
exports.actionButtonCss = actionButtonCss;
const disabledDraggableCss = (0, _css.css)`
  &.euiDraggable .euiDraggable__item.euiDraggable__item--isDisabled {
    cursor: unset;
  }
`;
exports.disabledDraggableCss = disabledDraggableCss;