"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _filter_item = require("./filter_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FilterItemsUI = /*#__PURE__*/_react.default.memo(function FilterItemsUI(props) {
  const groupRef = (0, _react.useRef)(null);
  const kibana = (0, _public.useKibana)();
  const {
    appName,
    usageCollection,
    uiSettings
  } = kibana.services;
  const {
    readOnly = false
  } = props;
  if (!uiSettings) return null;
  const reportUiCounter = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter.bind(usageCollection, appName);
  function onFiltersUpdated(filters) {
    if (props.onFiltersUpdated) {
      props.onFiltersUpdated(filters);
    }
  }
  function renderItems() {
    return props.filters.map((filter, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: i,
      grow: false,
      css: (0, _react2.css)`
          max-width: 100%;
        `
    }, /*#__PURE__*/_react.default.createElement(_filter_item.FilterItem, {
      id: `${i}`,
      intl: props.intl,
      filter: filter,
      onUpdate: newFilter => onUpdate(i, newFilter),
      onRemove: () => onRemove(i),
      indexPatterns: props.indexPatterns,
      uiSettings: uiSettings,
      hiddenPanelOptions: props.hiddenPanelOptions,
      timeRangeForSuggestionsOverride: props.timeRangeForSuggestionsOverride,
      filtersForSuggestions: props.filtersForSuggestions,
      readOnly: readOnly
    })));
  }
  function onRemove(i) {
    var _groupRef$current;
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:removed`);
    const filters = [...props.filters];
    filters.splice(i, 1);
    onFiltersUpdated(filters);
    (_groupRef$current = groupRef.current) === null || _groupRef$current === void 0 ? void 0 : _groupRef$current.focus();
  }
  function onUpdate(i, filter) {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:edited`);
    const filters = [...props.filters];
    filters[i] = filter;
    onFiltersUpdated(filters);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderItems());
});
const FilterItems = (0, _i18nReact.injectI18n)(FilterItemsUI);
// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = FilterItems;
exports.default = _default;
module.exports = exports.default;