"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhraseValueInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _generic_combo_box = require("./generic_combo_box");
var _phrase_suggestor = require("./phrase_suggestor");
var _value_input_type = require("./value_input_type");
var _truncated_label = require("./truncated_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_COMBOBOX_WIDTH = 250;
const COMBOBOX_PADDINGS = 10;
const DEFAULT_FONT = '14px Inter';
class PhraseValueInputUI extends _phrase_suggestor.PhraseSuggestorUI {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "comboBoxRef", void 0);
    this.comboBoxRef = /*#__PURE__*/_react.default.createRef();
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.isSuggestingValues() ? this.renderWithSuggestions() : /*#__PURE__*/_react.default.createElement(_value_input_type.ValueInputType, {
      disabled: this.props.disabled,
      compressed: this.props.compressed,
      fullWidth: this.props.fullWidth,
      placeholder: this.props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.valueInputPlaceholder',
        defaultMessage: 'Enter a value'
      }),
      value: this.props.value,
      onChange: this.props.onChange,
      field: this.props.field,
      isInvalid: this.props.invalid
    }));
  }
  renderWithSuggestions() {
    const {
      suggestions
    } = this.state;
    const {
      value,
      intl,
      onChange,
      fullWidth
    } = this.props;
    // there are cases when the value is a number, this would cause an exception
    const valueAsStr = String(value);
    const options = value ? (0, _lodash.uniq)([valueAsStr, ...suggestions]) : suggestions;
    return /*#__PURE__*/_react.default.createElement("div", {
      ref: this.comboBoxRef
    }, /*#__PURE__*/_react.default.createElement(StringComboBox, {
      isDisabled: this.props.disabled,
      fullWidth: fullWidth,
      compressed: this.props.compressed,
      placeholder: intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.valueSelectPlaceholder',
        defaultMessage: 'Select a value'
      }),
      "aria-label": intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.valueSelectPlaceholder',
        defaultMessage: 'Select a value'
      }),
      options: options,
      getLabel: option => option,
      selectedOptions: value ? [valueAsStr] : [],
      onChange: ([newValue = '']) => onChange(newValue),
      onSearchChange: this.onSearchChange,
      singleSelection: {
        asPlainText: true
      },
      onCreateOption: onChange,
      isClearable: false,
      "data-test-subj": "filterParamsComboBox phraseParamsComboxBox",
      renderOption: (option, searchValue) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_truncated_label.TruncatedLabel, {
        defaultComboboxWidth: DEFAULT_COMBOBOX_WIDTH,
        defaultFont: DEFAULT_FONT,
        comboboxPaddings: COMBOBOX_PADDINGS,
        comboBoxRef: this.comboBoxRef,
        label: option.label,
        search: searchValue
      })))
    }));
  }
}
function StringComboBox(props) {
  return (0, _generic_combo_box.GenericComboBox)(props);
}
const PhraseValueInput = (0, _i18nReact.injectI18n)((0, _public.withKibana)(PhraseValueInputUI));
exports.PhraseValueInput = PhraseValueInput;