"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewsListLazy = exports.DataViewsList = exports.DataViewSelectorLazy = exports.DataViewSelector = exports.DataViewPickerLazy = exports.DataViewPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * The Lazily-loaded `DataViewsList` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const DataViewsListLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./dataview_list'))));

/**
 * A `DataViewsList` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `DataViewsLazy` component lazily with
 * a predefined fallback and error boundary.
 */
exports.DataViewsListLazy = DataViewsListLazy;
const DataViewsList = (0, _sharedUxUtility.withSuspense)(DataViewsListLazy);

/**
 * The Lazily-loaded `DataViewSelector` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
exports.DataViewsList = DataViewsList;
const DataViewSelectorLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./data_view_selector'))));

/**
 * A `DataViewSelector` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `DataViewSelectorLazy` component lazily with
 * a predefined fallback and error boundary.
 */
exports.DataViewSelectorLazy = DataViewSelectorLazy;
const DataViewSelector = (0, _sharedUxUtility.withSuspense)(DataViewSelectorLazy);

/**
 * The Lazily-loaded `DataViewPicker` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
exports.DataViewSelector = DataViewSelector;
const DataViewPickerLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./data_view_picker'))));

/**
 * A `DataViewPicker` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `DataViewPickerLazy` component lazily with
 * a predefined fallback and error boundary.
 */
exports.DataViewPickerLazy = DataViewPickerLazy;
const DataViewPicker = (0, _sharedUxUtility.withSuspense)(DataViewPickerLazy);
exports.DataViewPicker = DataViewPicker;