"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupValueSuggestionProvider = exports.getEmptyValueSuggestions = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const getAutocompleteTimefilter = ({
  timefilter
}, indexPattern) => {
  const timeRange = timefilter.getTime();

  // Use a rounded timerange so that memoizing works properly
  const roundedTimerange = {
    from: _datemath.default.parse(timeRange.from).startOf('minute').toISOString(),
    to: _datemath.default.parse(timeRange.to, {
      roundUp: true
    }).endOf('minute').toISOString()
  };
  return timefilter.createFilter(indexPattern, roundedTimerange);
};
const getEmptyValueSuggestions = () => Promise.resolve([]);
exports.getEmptyValueSuggestions = getEmptyValueSuggestions;
const setupValueSuggestionProvider = (core, {
  timefilter,
  usageCollector
}) => {
  function resolver(title, field, query, filters) {
    // Only cache results for a minute
    const ttl = Math.floor(Date.now() / 1000 / 60);
    return [ttl, query, title, field.name, JSON.stringify(filters)].join('|');
  }
  const requestSuggestions = (0, _lodash.memoize)((index, field, query, filters = [], signal, method = core.uiSettings.get(_common.UI_SETTINGS.AUTOCOMPLETE_VALUE_SUGGESTION_METHOD)) => {
    var _field$toSpec;
    usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.trackRequest();
    return core.http.fetch(`/api/kibana/suggestions/values/${index}`, {
      method: 'POST',
      body: JSON.stringify({
        query,
        field: field.name,
        fieldMeta: field === null || field === void 0 ? void 0 : (_field$toSpec = field.toSpec) === null || _field$toSpec === void 0 ? void 0 : _field$toSpec.call(field),
        filters,
        method
      }),
      signal
    }).then(r => {
      usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.trackResult();
      return r;
    });
  }, resolver);
  return async ({
    indexPattern,
    field,
    query,
    useTimeRange,
    boolFilter,
    signal,
    method
  }) => {
    var _useTimeRange, _field$esTypes;
    const shouldSuggestValues = core.uiSettings.get(_common.UI_SETTINGS.FILTERS_EDITOR_SUGGEST_VALUES);
    useTimeRange = (_useTimeRange = useTimeRange) !== null && _useTimeRange !== void 0 ? _useTimeRange : core.uiSettings.get(_common.UI_SETTINGS.AUTOCOMPLETE_USE_TIMERANGE);
    const {
      title
    } = indexPattern;
    const isVersionFieldType = field.type === 'string' && ((_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.includes('version'));
    if (field.type === 'boolean') {
      return [true, false];
    } else if (!shouldSuggestValues || !field.aggregatable || field.type !== 'string' && field.type !== 'ip' || isVersionFieldType // suggestions don't work for version fields
    ) {
      return [];
    }
    const timeFilter = useTimeRange ? getAutocompleteTimefilter(timefilter, indexPattern) : undefined;
    const {
      buildQueryFromFilters
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
    const filterQuery = timeFilter ? buildQueryFromFilters([timeFilter], indexPattern).filter : [];
    const filters = [...(boolFilter ? boolFilter : []), ...filterQuery];
    try {
      usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.trackCall();
      return await requestSuggestions(title, field, query, filters, signal, method);
    } catch (e) {
      if (!(signal !== null && signal !== void 0 && signal.aborted)) {
        usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.trackError();
      }
      // Remove rejected results from memoize cache
      requestSuggestions.cache.delete(resolver(title, field, query, filters));
      return [];
    }
  };
};
exports.setupValueSuggestionProvider = setupValueSuggestionProvider;