"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupKqlQuerySuggestionProvider = exports.KUERY_LANGUAGE_NAME = void 0;
var _lodash = require("lodash");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const cursorSymbol = '@kuery-cursor@';
const dedup = suggestions => (0, _lodash.uniqBy)(suggestions, ({
  type,
  text,
  start,
  end
}) => [type, text, start, end].join('|'));
const KUERY_LANGUAGE_NAME = 'kuery';
exports.KUERY_LANGUAGE_NAME = KUERY_LANGUAGE_NAME;
const setupKqlQuerySuggestionProvider = core => {
  let getSuggestionsByType;
  const asyncGetSuggestionsByTypeFn = async () => {
    if (getSuggestionsByType) {
      return getSuggestionsByType;
    }
    const {
      setupGetFieldSuggestions,
      setupGetValueSuggestions,
      setupGetOperatorSuggestions,
      setupGetConjunctionSuggestions
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_loads')));
    const {
      fromKueryExpression
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
    const providers = {
      field: setupGetFieldSuggestions(core),
      value: setupGetValueSuggestions(core),
      operator: setupGetOperatorSuggestions(core),
      conjunction: setupGetConjunctionSuggestions(core)
    };
    return getSuggestionsByType = async (cursoredQuery, querySuggestionsArgs) => {
      try {
        const cursorNode = fromKueryExpression(cursoredQuery, {
          cursorSymbol,
          parseCursor: true
        });
        return cursorNode.suggestionTypes.map(type => providers[type](querySuggestionsArgs, cursorNode));
      } catch (e) {
        return [];
      }
    };
  };
  return async querySuggestionsArgs => {
    const {
      query,
      selectionStart,
      selectionEnd
    } = querySuggestionsArgs;
    const cursoredQuery = `${query.substr(0, selectionStart)}${cursorSymbol}${query.substr(selectionEnd)}`;
    const fn = await asyncGetSuggestionsByTypeFn();
    return Promise.all(await fn(cursoredQuery, querySuggestionsArgs)).then(suggestionsByType => dedup((0, _lodash.flatten)(suggestionsByType)));
  };
};
exports.setupKqlQuerySuggestionProvider = setupKqlQuerySuggestionProvider;