"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupGetFieldSuggestions = void 0;
var _public = require("@kbn/data-plugin/public");
var _lodash = require("lodash");
var _sort_prefix_first = require("./sort_prefix_first");
var _query_suggestion_provider = require("../query_suggestion_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const keywordComparator = (first, second) => {
  const extensions = ['raw', 'keyword'];
  if (extensions.map(ext => `${first.name}.${ext}`).includes(second.name)) {
    return 1;
  } else if (extensions.map(ext => `${second.name}.${ext}`).includes(first.name)) {
    return -1;
  }
  return first.name.localeCompare(second.name);
};
const setupGetFieldSuggestions = core => {
  return async ({
    indexPatterns
  }, {
    start,
    end,
    prefix,
    suffix,
    nestedPath = ''
  }) => {
    const allFields = (0, _lodash.flatten)(indexPatterns.map(indexPattern => {
      return indexPattern.fields.filter(_public.indexPatterns.isFilterable);
    })
    // temp until IIndexPattern => DataView
    );

    const search = `${prefix}${suffix}`.trim().toLowerCase();
    const matchingFields = allFields.filter(field => {
      const subTypeNested = _public.indexPatterns.getFieldSubtypeNested(field);
      return (!nestedPath || nestedPath && (subTypeNested === null || subTypeNested === void 0 ? void 0 : subTypeNested.nested.path.includes(nestedPath))) && field.name.toLowerCase().includes(search);
    });
    const sortedFields = (0, _sort_prefix_first.sortPrefixFirst)(matchingFields.sort(keywordComparator), search, 'name');
    const {
      escapeKuery
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
    const suggestions = sortedFields.map(field => {
      const remainingPath = field.subType && field.subType.nested ? field.subType.nested.path.slice(nestedPath ? nestedPath.length + 1 : 0) : '';
      const text = field.subType && field.subType.nested && remainingPath.length > 0 ? `${escapeKuery(remainingPath)}:{ ${escapeKuery(field.name.slice(field.subType.nested.path.length + 1))}  }` : `${escapeKuery(field.name.slice(nestedPath ? nestedPath.length + 1 : 0))} `;
      const cursorIndex = field.subType && field.subType.nested && remainingPath.length > 0 ? text.length - 2 : text.length;
      return {
        type: _query_suggestion_provider.QuerySuggestionTypes.Field,
        text,
        start,
        end,
        cursorIndex,
        field
      };
    });
    return Promise.resolve(suggestions);
  };
};
exports.setupGetFieldSuggestions = setupGetFieldSuggestions;