"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutocompleteService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _moment = _interopRequireDefault(require("moment"));
var _value_suggestion_provider = require("./providers/value_suggestion_provider");
var _collectors = require("./collectors");
var _kql_query_suggestion = require("./providers/kql_query_suggestion");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class AutocompleteService {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "autocompleteConfig", void 0);
    (0, _defineProperty2.default)(this, "querySuggestionProviders", new Map());
    (0, _defineProperty2.default)(this, "getValueSuggestions", void 0);
    (0, _defineProperty2.default)(this, "getQuerySuggestions", args => {
      const {
        language
      } = args;
      const provider = this.querySuggestionProviders.get(language);
      if (provider) {
        return provider(args);
      }
    });
    (0, _defineProperty2.default)(this, "hasQuerySuggestions", language => this.querySuggestionProviders.has(language));
    this.initializerContext = initializerContext;
    const {
      autocomplete
    } = initializerContext.config.get();
    this.autocompleteConfig = autocomplete;
  }
  /** @public **/
  setup(core, {
    timefilter,
    usageCollection
  }) {
    const {
      autocomplete
    } = this.initializerContext.config.get();
    const {
      terminateAfter,
      timeout
    } = autocomplete.valueSuggestions;
    const usageCollector = (0, _collectors.createUsageCollector)(core.getStartServices, usageCollection);
    this.getValueSuggestions = this.autocompleteConfig.valueSuggestions.enabled ? (0, _value_suggestion_provider.setupValueSuggestionProvider)(core, {
      timefilter,
      usageCollector
    }) : _value_suggestion_provider.getEmptyValueSuggestions;
    if (this.autocompleteConfig.querySuggestions.enabled) {
      this.querySuggestionProviders.set(_kql_query_suggestion.KUERY_LANGUAGE_NAME, (0, _kql_query_suggestion.setupKqlQuerySuggestionProvider)(core));
    }
    return {
      /**
       * @deprecated
       * please use "getQuerySuggestions" from the start contract
       */
      getQuerySuggestions: this.getQuerySuggestions,
      getAutocompleteSettings: () => ({
        terminateAfter: _moment.default.duration(terminateAfter).asMilliseconds(),
        timeout: _moment.default.duration(timeout).asMilliseconds()
      })
    };
  }

  /** @public **/
  start() {
    return {
      getQuerySuggestions: this.getQuerySuggestions,
      hasQuerySuggestions: this.hasQuerySuggestions,
      getValueSuggestions: this.getValueSuggestions
    };
  }

  /** @internal **/
  clearProviders() {
    this.querySuggestionProviders.clear();
  }
}

/** @public **/
exports.AutocompleteService = AutocompleteService;