"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_FILTER_REFERENCES_ACTION = void 0;
exports.createUpdateFilterReferencesAction = createUpdateFilterReferencesAction;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const UPDATE_FILTER_REFERENCES_ACTION = 'UPDATE_FILTER_REFERENCES_ACTION';
exports.UPDATE_FILTER_REFERENCES_ACTION = UPDATE_FILTER_REFERENCES_ACTION;
function createUpdateFilterReferencesAction(filterManager) {
  return {
    type: UPDATE_FILTER_REFERENCES_ACTION,
    id: UPDATE_FILTER_REFERENCES_ACTION,
    execute: async ({
      fromDataView,
      toDataView,
      usedDataViews,
      defaultDataView
    }) => {
      const countOfInitialDataView = usedDataViews.filter(i => i === fromDataView).length;
      const filters = filterManager.getFilters();

      /** no action needed **/
      if (countOfInitialDataView > 1 || !filters.length || !fromDataView) {
        return;
      }

      /** removing layer **/
      if (fromDataView && !toDataView) {
        if (usedDataViews.length > 1) {
          toDataView = usedDataViews.filter(item => item !== fromDataView)[0];
        }
        if (!toDataView && defaultDataView) {
          toDataView = defaultDataView;
        }
      }
      if (toDataView) {
        filterManager.setFilters(filters.map(filter => {
          if (filter.meta.index === fromDataView) {
            return {
              ...filter,
              meta: {
                ...filter.meta,
                index: toDataView
              }
            };
          } else {
            return filter;
          }
        }));
      }
    }
  };
}