"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HitsCounter = HitsCounter;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function HitsCounter({
  hits,
  append
}) {
  var _hits$total;
  if (!hits.total && hits.status === 'loading') {
    return null;
  }
  const formattedHits = /*#__PURE__*/_react.default.createElement("strong", {
    "data-test-subj": hits.status === 'partial' ? 'unifiedHistogramQueryHitsPartial' : 'unifiedHistogramQueryHits'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
    value: (_hits$total = hits.total) !== null && _hits$total !== void 0 ? _hits$total : 0
  }));
  const hitsCounterCss = (0, _react2.css)`
    flex-grow: 0;
  `;
  const hitsCounterTextCss = (0, _react2.css)`
    overflow: hidden;
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    justifyContent: "center",
    alignItems: "center",
    css: hitsCounterCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "aria-live": "polite",
    css: hitsCounterTextCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textTruncate"
  }, hits.status === 'partial' && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedHistogram.partialHits",
    defaultMessage: "\u2265{formattedHits} {hits, plural, one {hit} other {hits}}",
    values: {
      hits: hits.total,
      formattedHits
    }
  }), hits.status !== 'partial' && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedHistogram.hitsPluralTitle",
    defaultMessage: "{formattedHits} {hits, plural, one {hit} other {hits}}",
    values: {
      hits: hits.total,
      formattedHits
    }
  }))), hits.status === 'partial' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "aria-label": _i18n.i18n.translate('unifiedHistogram.hitCountSpinnerAriaLabel', {
      defaultMessage: 'Final hit count still loading'
    })
  })), append);
}