"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStateSelector = void 0;
var _operators = require("rxjs/operators");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useStateSelector = (state$, selector, equalityFn) => {
  const [state, setState] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const subscription = state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _operators.map)(selector), (0, _operators.distinctUntilChanged)(equalityFn)).subscribe(setState);
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [equalityFn, selector, state$]);
  return state;
};
exports.useStateSelector = useStateSelector;