"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStateProps = void 0;
var _common = require("@kbn/data-views-plugin/common");
var _esQuery = require("@kbn/es-query");
var _react = require("react");
var _state_selectors = require("../utils/state_selectors");
var _use_state_selector = require("../utils/use_state_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useStateProps = ({
  stateService,
  dataView,
  query,
  searchSessionId,
  requestAdapter
}) => {
  const breakdownField = (0, _use_state_selector.useStateSelector)(stateService === null || stateService === void 0 ? void 0 : stateService.state$, _state_selectors.breakdownFieldSelector);
  const chartHidden = (0, _use_state_selector.useStateSelector)(stateService === null || stateService === void 0 ? void 0 : stateService.state$, _state_selectors.chartHiddenSelector);
  const timeInterval = (0, _use_state_selector.useStateSelector)(stateService === null || stateService === void 0 ? void 0 : stateService.state$, _state_selectors.timeIntervalSelector);
  const totalHitsResult = (0, _use_state_selector.useStateSelector)(stateService === null || stateService === void 0 ? void 0 : stateService.state$, _state_selectors.totalHitsResultSelector);
  const totalHitsStatus = (0, _use_state_selector.useStateSelector)(stateService === null || stateService === void 0 ? void 0 : stateService.state$, _state_selectors.totalHitsStatusSelector);

  /**
   * Contexts
   */

  const isPlainRecord = (0, _react.useMemo)(() => {
    return query && (0, _esQuery.isOfAggregateQueryType)(query) && ['sql', 'esql'].some(mode => mode === (0, _esQuery.getAggregateQueryMode)(query));
  }, [query]);
  const isTimeBased = (0, _react.useMemo)(() => {
    return dataView && dataView.type !== _common.DataViewType.ROLLUP && dataView.isTimeBased();
  }, [dataView]);
  const hits = (0, _react.useMemo)(() => {
    if (totalHitsResult instanceof Error) {
      return undefined;
    }
    return {
      status: totalHitsStatus,
      total: totalHitsResult
    };
  }, [totalHitsResult, totalHitsStatus]);
  const chart = (0, _react.useMemo)(() => {
    if (!isTimeBased && !isPlainRecord) {
      return undefined;
    }
    return {
      hidden: chartHidden,
      timeInterval
    };
  }, [chartHidden, isPlainRecord, isTimeBased, timeInterval]);
  const breakdown = (0, _react.useMemo)(() => {
    if (isPlainRecord || !isTimeBased) {
      return undefined;
    }
    return {
      field: breakdownField ? dataView === null || dataView === void 0 ? void 0 : dataView.getFieldByName(breakdownField) : undefined
    };
  }, [breakdownField, dataView, isPlainRecord, isTimeBased]);
  const request = (0, _react.useMemo)(() => {
    return {
      searchSessionId,
      adapter: requestAdapter
    };
  }, [requestAdapter, searchSessionId]);

  /**
   * Callbacks
   */

  const onTopPanelHeightChange = (0, _react.useCallback)(topPanelHeight => {
    stateService === null || stateService === void 0 ? void 0 : stateService.setTopPanelHeight(topPanelHeight);
  }, [stateService]);
  const onTimeIntervalChange = (0, _react.useCallback)(newTimeInterval => {
    stateService === null || stateService === void 0 ? void 0 : stateService.setTimeInterval(newTimeInterval);
  }, [stateService]);
  const onTotalHitsChange = (0, _react.useCallback)((newTotalHitsStatus, newTotalHitsResult) => {
    stateService === null || stateService === void 0 ? void 0 : stateService.setTotalHits({
      totalHitsStatus: newTotalHitsStatus,
      totalHitsResult: newTotalHitsResult
    });
  }, [stateService]);
  const onChartHiddenChange = (0, _react.useCallback)(newChartHidden => {
    stateService === null || stateService === void 0 ? void 0 : stateService.setChartHidden(newChartHidden);
  }, [stateService]);
  const onChartLoad = (0, _react.useCallback)(event => {
    // We need to store the Lens request adapter in order to inspect its requests
    stateService === null || stateService === void 0 ? void 0 : stateService.setLensRequestAdapter(event.adapters.requests);
  }, [stateService]);
  const onBreakdownFieldChange = (0, _react.useCallback)(newBreakdownField => {
    stateService === null || stateService === void 0 ? void 0 : stateService.setBreakdownField(newBreakdownField === null || newBreakdownField === void 0 ? void 0 : newBreakdownField.name);
  }, [stateService]);
  const onSuggestionChange = (0, _react.useCallback)(suggestion => {
    stateService === null || stateService === void 0 ? void 0 : stateService.setCurrentSuggestion(suggestion);
  }, [stateService]);

  /**
   * Effects
   */

  // Clear the Lens request adapter when the chart is hidden
  (0, _react.useEffect)(() => {
    if (chartHidden || !chart) {
      stateService === null || stateService === void 0 ? void 0 : stateService.setLensRequestAdapter(undefined);
    }
  }, [chart, chartHidden, stateService]);
  return {
    hits,
    chart,
    breakdown,
    request,
    isPlainRecord,
    onTopPanelHeightChange,
    onTimeIntervalChange,
    onTotalHitsChange,
    onChartHiddenChange,
    onChartLoad,
    onBreakdownFieldChange,
    onSuggestionChange
  };
};
exports.useStateProps = useStateProps;