"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensAttributes = void 0;
var _i18n = require("@kbn/i18n");
var _field_supports_breakdown = require("./field_supports_breakdown");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getLensAttributes = ({
  title,
  filters,
  query,
  dataView,
  timeInterval,
  breakdownField,
  suggestion
}) => {
  var _dataView$timeFieldNa, _dataView$id, _dataView$id2;
  const showBreakdown = breakdownField && (0, _field_supports_breakdown.fieldSupportsBreakdown)(breakdownField);
  let columnOrder = ['date_column', 'count_column'];
  if (showBreakdown) {
    columnOrder = ['breakdown_column', ...columnOrder];
  }
  let columns = {
    date_column: {
      dataType: 'date',
      isBucketed: true,
      label: (_dataView$timeFieldNa = dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : '',
      operationType: 'date_histogram',
      scale: 'interval',
      sourceField: dataView.timeFieldName,
      params: {
        interval: timeInterval !== null && timeInterval !== void 0 ? timeInterval : 'auto'
      }
    },
    count_column: {
      dataType: 'number',
      isBucketed: false,
      label: _i18n.i18n.translate('unifiedHistogram.countColumnLabel', {
        defaultMessage: 'Count of records'
      }),
      operationType: 'count',
      scale: 'ratio',
      sourceField: '___records___',
      params: {
        format: {
          id: 'number',
          params: {
            decimals: 0
          }
        }
      }
    }
  };
  if (showBreakdown) {
    columns = {
      ...columns,
      breakdown_column: {
        dataType: 'string',
        isBucketed: true,
        label: _i18n.i18n.translate('unifiedHistogram.breakdownColumnLabel', {
          defaultMessage: 'Top 3 values of {fieldName}',
          values: {
            fieldName: breakdownField === null || breakdownField === void 0 ? void 0 : breakdownField.displayName
          }
        }),
        operationType: 'terms',
        scale: 'ordinal',
        sourceField: breakdownField.name,
        params: {
          size: 3,
          orderBy: {
            type: 'column',
            columnId: 'count_column'
          },
          orderDirection: 'desc',
          otherBucket: true,
          missingBucket: false,
          parentFormat: {
            id: 'terms'
          }
        }
      }
    };
  }
  const suggestionDatasourceState = Object.assign({}, suggestion === null || suggestion === void 0 ? void 0 : suggestion.datasourceState);
  const suggestionVisualizationState = Object.assign({}, suggestion === null || suggestion === void 0 ? void 0 : suggestion.visualizationState);
  const datasourceStates = suggestion && suggestion.datasourceState ? {
    [suggestion.datasourceId]: {
      ...suggestionDatasourceState
    }
  } : {
    formBased: {
      layers: {
        unifiedHistogram: {
          columnOrder,
          columns
        }
      }
    }
  };
  const visualization = suggestion ? {
    ...suggestionVisualizationState
  } : {
    layers: [{
      accessors: ['count_column'],
      layerId: 'unifiedHistogram',
      layerType: 'data',
      seriesType: 'bar_stacked',
      xAccessor: 'date_column',
      ...(showBreakdown ? {
        splitAccessor: 'breakdown_column'
      } : {
        yConfig: [{
          forAccessor: 'count_column'
        }]
      })
    }],
    legend: {
      isVisible: true,
      position: 'right'
    },
    preferredSeriesType: 'bar_stacked',
    valueLabels: 'hide',
    fittingFunction: 'None',
    showCurrentTimeMarker: true,
    axisTitlesVisibilitySettings: {
      x: false,
      yLeft: false,
      yRight: false
    },
    gridlinesVisibilitySettings: {
      x: true,
      yLeft: true,
      yRight: false
    },
    tickLabelsVisibilitySettings: {
      x: true,
      yLeft: true,
      yRight: false
    }
  };
  const attributes = {
    title: title !== null && title !== void 0 ? title : _i18n.i18n.translate('unifiedHistogram.lensTitle', {
      defaultMessage: 'Edit visualization'
    }),
    references: [{
      id: (_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : '',
      name: 'indexpattern-datasource-current-indexpattern',
      type: 'index-pattern'
    }, {
      id: (_dataView$id2 = dataView.id) !== null && _dataView$id2 !== void 0 ? _dataView$id2 : '',
      name: 'indexpattern-datasource-layer-unifiedHistogram',
      type: 'index-pattern'
    }],
    state: {
      datasourceStates,
      filters,
      query,
      visualization
    },
    visualizationType: suggestion ? suggestion.visualizationId : 'lnsXY'
  };
  return {
    attributes,
    requestData: {
      dataViewId: dataView.id,
      timeField: dataView.timeFieldName,
      timeInterval,
      breakdownField: breakdownField === null || breakdownField === void 0 ? void 0 : breakdownField.name
    }
  };
};
exports.getLensAttributes = getLensAttributes;