"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStableCallback = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Accepts a callback and returns a function with a stable identity
 * that will always call the latest version of the callback when invoked
 */
const useStableCallback = fn => {
  const ref = (0, _react.useRef)(fn);
  (0, _react.useEffect)(() => {
    ref.current = fn;
  }, [fn]);
  return (0, _react.useRef)((...args) => {
    var _ref$current;
    return (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.call(ref, ...args);
  }).current;
};
exports.useStableCallback = useStableCallback;