"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefetch = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useRefetch = ({
  dataView,
  request,
  hits,
  chart,
  chartVisible,
  breakdown,
  filters,
  query,
  relativeTimeRange,
  currentSuggestion,
  disableAutoFetching,
  input$,
  beforeRefetch
}) => {
  const refetchDeps = (0, _react.useRef)();

  // When the Unified Histogram props change, we must compare the current subset
  // that should trigger a histogram refetch against the previous subset. If they
  // are different, we must refetch the histogram to ensure it's up to date.
  (0, _react.useEffect)(() => {
    // Skip if auto fetching if disabled
    if (disableAutoFetching) {
      return;
    }
    const newRefetchDeps = getRefetchDeps({
      dataView,
      request,
      hits,
      chart,
      chartVisible,
      breakdown,
      filters,
      query,
      relativeTimeRange,
      currentSuggestion
    });
    if (!(0, _lodash.isEqual)(refetchDeps.current, newRefetchDeps)) {
      if (refetchDeps.current) {
        input$.next({
          type: 'refetch'
        });
      }
      refetchDeps.current = newRefetchDeps;
    }
  }, [breakdown, chart, chartVisible, currentSuggestion, dataView, disableAutoFetching, filters, hits, input$, query, relativeTimeRange, request]);
  return (0, _react.useMemo)(() => input$.pipe((0, _rxjs.filter)(message => message.type === 'refetch'), (0, _rxjs.tap)(beforeRefetch), (0, _rxjs.share)()), [beforeRefetch, input$]);
};
exports.useRefetch = useRefetch;
const getRefetchDeps = ({
  dataView,
  request,
  hits,
  chart,
  chartVisible,
  breakdown,
  filters,
  query,
  relativeTimeRange,
  currentSuggestion
}) => (0, _lodash.cloneDeep)([dataView.id, request === null || request === void 0 ? void 0 : request.searchSessionId, Boolean(hits), chartVisible, chart === null || chart === void 0 ? void 0 : chart.timeInterval, Boolean(breakdown), breakdown === null || breakdown === void 0 ? void 0 : breakdown.field, filters, query, relativeTimeRange, currentSuggestion === null || currentSuggestion === void 0 ? void 0 : currentSuggestion.visualizationId]);