"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditVisualization = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Avoid taking a dependency on uiActionsPlugin just for this const
const visualizeFieldTrigger = 'VISUALIZE_FIELD_TRIGGER';
const useEditVisualization = ({
  services,
  dataView,
  relativeTimeRange,
  lensAttributes
}) => {
  const [canVisualize, setCanVisualize] = (0, _react.useState)(false);
  const checkCanVisualize = (0, _react.useCallback)(async () => {
    if (!dataView.id || !dataView.isTimeBased() || !dataView.getTimeField().visualizable) {
      return false;
    }
    const compatibleActions = await services.uiActions.getTriggerCompatibleActions(visualizeFieldTrigger, {
      dataViewSpec: dataView.toSpec(false),
      fieldName: dataView.timeFieldName
    });
    return Boolean(compatibleActions.length);
  }, [dataView, services.uiActions]);
  const onEditVisualization = (0, _react.useMemo)(() => {
    if (!canVisualize) {
      return undefined;
    }
    return () => {
      services.lens.navigateToPrefilledEditor({
        id: '',
        timeRange: relativeTimeRange,
        attributes: lensAttributes
      });
    };
  }, [canVisualize, lensAttributes, relativeTimeRange, services.lens]);
  (0, _react.useEffect)(() => {
    checkCanVisualize().then(setCanVisualize);
  }, [checkCanVisualize]);
  return onEditVisualization;
};
exports.useEditVisualization = useEditVisualization;