"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useChartStyles = chartVisible => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const resultCountCss = (0, _react.css)`
    padding: ${euiTheme.size.s} ${euiTheme.size.s} ${chartVisible ? 0 : euiTheme.size.s}
      ${euiTheme.size.s};
    min-height: ${euiTheme.base * 2.5}px;
  `;
  const resultCountInnerCss = (0, _react.css)`
    ${(0, _eui.useEuiBreakpoint)(['xs', 's'])} {
      align-items: center;
    }
  `;
  const resultCountTitleCss = (0, _react.css)`
    flex-basis: auto;

    ${(0, _eui.useEuiBreakpoint)(['xs', 's'])} {
      margin-bottom: 0 !important;
    }
  `;
  const resultCountToggleCss = (0, _react.css)`
    flex-basis: auto;
    min-width: 0;

    ${(0, _eui.useEuiBreakpoint)(['xs', 's'])} {
      align-items: flex-end;
    }
  `;
  const histogramCss = (0, _react.css)`
    flex-grow: 1;
    display: flex;
    flex-direction: column;
    position: relative;

    // SASSTODO: the visualizing component should have an option or a modifier
    .series > rect {
      fill-opacity: 0.5;
      stroke-width: 1;
    }
  `;
  const breakdownFieldSelectorGroupCss = (0, _react.css)`
    width: 100%;
  `;
  const breakdownFieldSelectorItemCss = (0, _react.css)`
    min-width: 0;
    align-items: flex-end;
    padding-left: ${euiTheme.size.s};
  `;
  const chartToolButtonCss = (0, _react.css)`
    display: flex;
    justify-content: center;
    padding-left: ${euiTheme.size.s};
  `;
  return {
    resultCountCss,
    resultCountInnerCss,
    resultCountTitleCss,
    resultCountToggleCss,
    histogramCss,
    breakdownFieldSelectorGroupCss,
    breakdownFieldSelectorItemCss,
    chartToolButtonCss
  };
};
exports.useChartStyles = useChartStyles;