"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Histogram = Histogram;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _public = require("@kbn/inspector-plugin/public");
var _types = require("../types");
var _build_bucket_interval = require("./utils/build_bucket_interval");
var _use_time_range = require("./hooks/use_time_range");
var _use_stable_callback = require("./hooks/use_stable_callback");
var _use_lens_props = require("./hooks/use_lens_props");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function Histogram({
  services: {
    data,
    lens,
    uiSettings
  },
  dataView,
  request,
  hits,
  chart: {
    timeInterval
  },
  isPlainRecord,
  getTimeRange,
  refetch$,
  lensAttributesContext: attributesContext,
  disableTriggers,
  disabledActions,
  onTotalHitsChange,
  onChartLoad,
  onFilter,
  onBrushEnd
}) {
  const [bucketInterval, setBucketInterval] = (0, _react2.useState)();
  const [chartSize, setChartSize] = (0, _react2.useState)('100%');
  const {
    timeRangeText,
    timeRangeDisplay
  } = (0, _use_time_range.useTimeRange)({
    uiSettings,
    bucketInterval,
    timeRange: getTimeRange(),
    timeInterval,
    isPlainRecord
  });
  const chartRef = (0, _react2.useRef)(null);
  const {
    height: containerHeight,
    width: containerWidth
  } = (0, _eui.useResizeObserver)(chartRef.current);
  const {
    attributes
  } = attributesContext;
  (0, _react2.useEffect)(() => {
    if (attributes.visualizationType === 'lnsMetric') {
      const size = containerHeight < containerWidth ? containerHeight : containerWidth;
      setChartSize(`${size}px`);
    } else {
      setChartSize('100%');
    }
  }, [attributes, containerHeight, containerWidth]);
  const onLoad = (0, _use_stable_callback.useStableCallback)((isLoading, adapters) => {
    var _adapters$requests, _lensRequest$response, _adapters$tables, _Object$values, _Object$values$, _Object$values$$rows, _adapterTables$unifie, _adapterTables$unifie2, _adapterTables$unifie3;
    const lensRequest = adapters === null || adapters === void 0 ? void 0 : (_adapters$requests = adapters.requests) === null || _adapters$requests === void 0 ? void 0 : _adapters$requests.getRequests()[0];
    const requestFailed = (lensRequest === null || lensRequest === void 0 ? void 0 : lensRequest.status) === _public.RequestStatus.ERROR;
    const json = lensRequest === null || lensRequest === void 0 ? void 0 : (_lensRequest$response = lensRequest.response) === null || _lensRequest$response === void 0 ? void 0 : _lensRequest$response.json;
    const response = json === null || json === void 0 ? void 0 : json.rawResponse;

    // Lens will swallow shard failures and return `isLoading: false` because it displays
    // its own errors, but this causes us to emit onTotalHitsChange(UnifiedHistogramFetchStatus.complete, 0).
    // This is incorrect, so we check for request failures and shard failures here, and emit an error instead.
    if (requestFailed || response !== null && response !== void 0 && response._shards.failed) {
      onTotalHitsChange === null || onTotalHitsChange === void 0 ? void 0 : onTotalHitsChange(_types.UnifiedHistogramFetchStatus.error, undefined);
      onChartLoad === null || onChartLoad === void 0 ? void 0 : onChartLoad({
        adapters: adapters !== null && adapters !== void 0 ? adapters : {}
      });
      return;
    }
    const adapterTables = adapters === null || adapters === void 0 ? void 0 : (_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : _adapters$tables.tables;
    const totalHits = isPlainRecord ? (_Object$values = Object.values(adapterTables !== null && adapterTables !== void 0 ? adapterTables : {})) === null || _Object$values === void 0 ? void 0 : (_Object$values$ = _Object$values[0]) === null || _Object$values$ === void 0 ? void 0 : (_Object$values$$rows = _Object$values$.rows) === null || _Object$values$$rows === void 0 ? void 0 : _Object$values$$rows.length : adapterTables === null || adapterTables === void 0 ? void 0 : (_adapterTables$unifie = adapterTables.unifiedHistogram) === null || _adapterTables$unifie === void 0 ? void 0 : (_adapterTables$unifie2 = _adapterTables$unifie.meta) === null || _adapterTables$unifie2 === void 0 ? void 0 : (_adapterTables$unifie3 = _adapterTables$unifie2.statistics) === null || _adapterTables$unifie3 === void 0 ? void 0 : _adapterTables$unifie3.totalCount;
    onTotalHitsChange === null || onTotalHitsChange === void 0 ? void 0 : onTotalHitsChange(isLoading ? _types.UnifiedHistogramFetchStatus.loading : _types.UnifiedHistogramFetchStatus.complete, totalHits !== null && totalHits !== void 0 ? totalHits : hits === null || hits === void 0 ? void 0 : hits.total);
    if (response) {
      const newBucketInterval = (0, _build_bucket_interval.buildBucketInterval)({
        data,
        dataView,
        timeInterval,
        timeRange: getTimeRange(),
        response
      });
      setBucketInterval(newBucketInterval);
    }
    onChartLoad === null || onChartLoad === void 0 ? void 0 : onChartLoad({
      adapters: adapters !== null && adapters !== void 0 ? adapters : {}
    });
  });
  const {
    lensProps,
    requestData
  } = (0, _use_lens_props.useLensProps)({
    request,
    getTimeRange,
    refetch$,
    attributesContext,
    onLoad
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartCss = (0, _react.css)`
    position: relative;
    flex-grow: 1;

    & > div {
      height: 100%;
      position: absolute;
      width: 100%;
    }

    & .lnsExpressionRenderer {
      width: ${chartSize};
      margin: auto;
    }

    & .echLegend .echLegendList {
      padding-right: ${euiTheme.size.s};
    }

    & > .euiLoadingChart {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
    }
  `;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "unifiedHistogramChart",
    "data-time-range": timeRangeText,
    "data-request-data": requestData,
    css: chartCss,
    ref: chartRef
  }, /*#__PURE__*/_react2.default.createElement(lens.EmbeddableComponent, (0, _extends2.default)({}, lensProps, {
    disableTriggers: disableTriggers,
    disabledActions: disabledActions,
    onFilter: onFilter,
    onBrushEnd: onBrushEnd
  }))), timeRangeDisplay);
}