"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNKNOWN_FIELD_TYPE_MESSAGE = void 0;
exports.getFieldTypeName = getFieldTypeName;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _field_types = require("./field_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A user-friendly name of an unknown field type
 */
const UNKNOWN_FIELD_TYPE_MESSAGE = _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.unknownFieldAriaLabel', {
  defaultMessage: 'Unknown field'
});

/**
 * Returns a user-friendly name of a field type
 * @param type
 * @public
 */
exports.UNKNOWN_FIELD_TYPE_MESSAGE = UNKNOWN_FIELD_TYPE_MESSAGE;
function getFieldTypeName(type) {
  if (!type || type === _public.KBN_FIELD_TYPES.UNKNOWN) {
    return UNKNOWN_FIELD_TYPE_MESSAGE;
  }
  if (type === 'source') {
    // Note that this type is currently not provided, type for _source is undefined
    return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.sourceFieldAriaLabel', {
      defaultMessage: 'Source field'
    });
  }
  const knownType = type;
  switch (knownType) {
    case _field_types.KNOWN_FIELD_TYPES.DOCUMENT:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.recordAriaLabel', {
        defaultMessage: 'Records'
      });
    case _field_types.KNOWN_FIELD_TYPES.BINARY:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.binaryAriaLabel', {
        defaultMessage: 'Binary'
      });
    case _field_types.KNOWN_FIELD_TYPES.BOOLEAN:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.booleanAriaLabel', {
        defaultMessage: 'Boolean'
      });
    case _field_types.KNOWN_FIELD_TYPES.CONFLICT:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.conflictFieldAriaLabel', {
        defaultMessage: 'Conflict'
      });
    case _field_types.KNOWN_FIELD_TYPES.COUNTER:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.counterFieldAriaLabel', {
        defaultMessage: 'Counter metric'
      });
    case _field_types.KNOWN_FIELD_TYPES.DATE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.dateFieldAriaLabel', {
        defaultMessage: 'Date'
      });
    case _field_types.KNOWN_FIELD_TYPES.DATE_RANGE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.dateRangeFieldAriaLabel', {
        defaultMessage: 'Date range'
      });
    case _field_types.KNOWN_FIELD_TYPES.DENSE_VECTOR:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.denseVectorFieldAriaLabel', {
        defaultMessage: 'Dense vector'
      });
    case _field_types.KNOWN_FIELD_TYPES.GAUGE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.gaugeFieldAriaLabel', {
        defaultMessage: 'Gauge metric'
      });
    case _field_types.KNOWN_FIELD_TYPES.GEO_POINT:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.geoPointFieldAriaLabel', {
        defaultMessage: 'Geo point'
      });
    case _field_types.KNOWN_FIELD_TYPES.GEO_SHAPE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.geoShapeFieldAriaLabel', {
        defaultMessage: 'Geo shape'
      });
    case _field_types.KNOWN_FIELD_TYPES.HISTOGRAM:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.histogramFieldAriaLabel', {
        defaultMessage: 'Histogram'
      });
    case _field_types.KNOWN_FIELD_TYPES.IP:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.ipAddressFieldAriaLabel', {
        defaultMessage: 'IP address'
      });
    case _field_types.KNOWN_FIELD_TYPES.IP_RANGE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.ipRangeFieldAriaLabel', {
        defaultMessage: 'IP range'
      });
    case _field_types.KNOWN_FIELD_TYPES.FLATTENED:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.flattenedFieldAriaLabel', {
        defaultMessage: 'Flattened'
      });
    case _field_types.KNOWN_FIELD_TYPES.MURMUR3:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.murmur3FieldAriaLabel', {
        defaultMessage: 'Murmur3'
      });
    case _field_types.KNOWN_FIELD_TYPES.NUMBER:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.numberFieldAriaLabel', {
        defaultMessage: 'Number'
      });
    case _field_types.KNOWN_FIELD_TYPES.RANK_FEATURE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.rankFeatureFieldAriaLabel', {
        defaultMessage: 'Rank feature'
      });
    case _field_types.KNOWN_FIELD_TYPES.RANK_FEATURES:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.rankFeaturesFieldAriaLabel', {
        defaultMessage: 'Rank features'
      });
    case _field_types.KNOWN_FIELD_TYPES.POINT:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.pointFieldAriaLabel', {
        defaultMessage: 'Point'
      });
    case _field_types.KNOWN_FIELD_TYPES.SHAPE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.shapeFieldAriaLabel', {
        defaultMessage: 'Shape'
      });
    case _field_types.KNOWN_FIELD_TYPES.STRING:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.stringFieldAriaLabel', {
        defaultMessage: 'String'
      });
    case _field_types.KNOWN_FIELD_TYPES.TEXT:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.textFieldAriaLabel', {
        defaultMessage: 'Text'
      });
    case _field_types.KNOWN_FIELD_TYPES.KEYWORD:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.keywordFieldAriaLabel', {
        defaultMessage: 'Keyword'
      });
    case _field_types.KNOWN_FIELD_TYPES.NESTED:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.nestedFieldAriaLabel', {
        defaultMessage: 'Nested'
      });
    case _field_types.KNOWN_FIELD_TYPES.VERSION:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameIcons.versionFieldAriaLabel', {
        defaultMessage: 'Version'
      });
    default:
      // If you see a typescript error here, that's a sign that there are missing switch cases ^^
      const _exhaustiveCheck = knownType;
      return knownType || _exhaustiveCheck;
  }
}