"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldType = getFieldType;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Returns a field type. Time series metric type will override the original field type.
 * @param field
 */
function getFieldType(field) {
  var _field$type;
  const timeSeriesMetric = field.timeSeriesMetric;
  if (timeSeriesMetric) {
    return timeSeriesMetric;
  }
  return (_field$type = field.type) !== null && _field$type !== void 0 ? _field$type : 'string';
}