"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isKnownFieldType = exports.KNOWN_FIELD_TYPE_LIST = exports.KNOWN_FIELD_TYPES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Field types for which name and description are defined
 * @public
 */
let KNOWN_FIELD_TYPES;
exports.KNOWN_FIELD_TYPES = KNOWN_FIELD_TYPES;
(function (KNOWN_FIELD_TYPES) {
  KNOWN_FIELD_TYPES["DOCUMENT"] = "document";
  KNOWN_FIELD_TYPES["BINARY"] = "binary";
  KNOWN_FIELD_TYPES["BOOLEAN"] = "boolean";
  KNOWN_FIELD_TYPES["CONFLICT"] = "conflict";
  KNOWN_FIELD_TYPES["COUNTER"] = "counter";
  KNOWN_FIELD_TYPES["DATE"] = "date";
  KNOWN_FIELD_TYPES["DATE_RANGE"] = "date_range";
  KNOWN_FIELD_TYPES["DENSE_VECTOR"] = "dense_vector";
  KNOWN_FIELD_TYPES["GAUGE"] = "gauge";
  KNOWN_FIELD_TYPES["GEO_POINT"] = "geo_point";
  KNOWN_FIELD_TYPES["GEO_SHAPE"] = "geo_shape";
  KNOWN_FIELD_TYPES["HISTOGRAM"] = "histogram";
  KNOWN_FIELD_TYPES["IP"] = "ip";
  KNOWN_FIELD_TYPES["IP_RANGE"] = "ip_range";
  KNOWN_FIELD_TYPES["FLATTENED"] = "flattened";
  KNOWN_FIELD_TYPES["KEYWORD"] = "keyword";
  KNOWN_FIELD_TYPES["MURMUR3"] = "murmur3";
  KNOWN_FIELD_TYPES["NUMBER"] = "number";
  KNOWN_FIELD_TYPES["NESTED"] = "nested";
  KNOWN_FIELD_TYPES["RANK_FEATURE"] = "rank_feature";
  KNOWN_FIELD_TYPES["RANK_FEATURES"] = "rank_features";
  KNOWN_FIELD_TYPES["POINT"] = "point";
  KNOWN_FIELD_TYPES["SHAPE"] = "shape";
  KNOWN_FIELD_TYPES["STRING"] = "string";
  KNOWN_FIELD_TYPES["TEXT"] = "text";
  KNOWN_FIELD_TYPES["VERSION"] = "version";
})(KNOWN_FIELD_TYPES || (exports.KNOWN_FIELD_TYPES = KNOWN_FIELD_TYPES = {}));
const KNOWN_FIELD_TYPE_LIST = Object.values(KNOWN_FIELD_TYPES);
exports.KNOWN_FIELD_TYPE_LIST = KNOWN_FIELD_TYPE_LIST;
const isKnownFieldType = type => {
  return !!type && KNOWN_FIELD_TYPE_LIST.includes(type);
};
exports.isKnownFieldType = isKnownFieldType;