"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadFieldStats = void 0;
var _rxjs = require("rxjs");
var _field_stats_utils = require("../../../common/utils/field_stats_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Loads and aggregates stats data for a data view field
 * @param services
 * @param dataView
 * @param field
 * @param fromDate
 * @param toDate
 * @param dslQuery
 * @param size
 * @param abortController
 */
const loadFieldStats = async ({
  services,
  dataView,
  field,
  fromDate,
  toDate,
  dslQuery,
  size,
  abortController
}) => {
  const {
    data
  } = services;
  try {
    if (!(dataView !== null && dataView !== void 0 && dataView.id) || !(field !== null && field !== void 0 && field.type)) {
      return {};
    }
    const searchHandler = async body => {
      const result = await (0, _rxjs.lastValueFrom)(data.search.search({
        params: (0, _field_stats_utils.buildSearchParams)({
          dataViewPattern: dataView.title,
          timeFieldName: dataView.timeFieldName,
          fromDate,
          toDate,
          dslQuery,
          runtimeMappings: dataView.getRuntimeMappings(),
          ...body
        })
      }, {
        abortSignal: abortController === null || abortController === void 0 ? void 0 : abortController.signal
      }));
      return result.rawResponse;
    };
    return await (0, _field_stats_utils.fetchAndCalculateFieldStats)({
      searchHandler,
      dataView,
      field,
      fromDate,
      toDate,
      size
    });
  } catch (error) {
    // console.error(error);
    throw new Error('Could not provide field stats', {
      cause: error
    });
  }
};
exports.loadFieldStats = loadFieldStats;