"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadFieldExisting = void 0;
var _public = require("@kbn/data-plugin/public");
var _rxjs = require("rxjs");
var _field_existing_utils = require("../../../common/utils/field_existing_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const loadFieldExisting = async ({
  data,
  dslQuery,
  fromDate,
  toDate,
  timeFieldName,
  dataViewsService,
  uiSettingsClient,
  dataView
}) => {
  const includeFrozen = uiSettingsClient.get(_public.UI_SETTINGS.SEARCH_INCLUDE_FROZEN);
  const metaFields = uiSettingsClient.get(_public.UI_SETTINGS.META_FIELDS);
  return await (0, _field_existing_utils.fetchFieldExistence)({
    dslQuery,
    fromDate,
    toDate,
    timeFieldName,
    dataViewsService,
    includeFrozen,
    metaFields,
    dataView,
    search: async params => {
      const response = await (0, _rxjs.lastValueFrom)(data.search.search({
        params
      }));
      return response.rawResponse;
    }
  });
};
exports.loadFieldExisting = loadFieldExisting;