"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldTopValuesBucket = ({
  'data-test-subj': dataTestSubject,
  onAddFilter,
  overrideFieldTopValueBar,
  ...fieldTopValuesBucketOverridableProps
}) => {
  var _multi$parent, _field$subType, _field$subType$multi, _formattedFieldValue$;
  const overrides = overrideFieldTopValueBar ? overrideFieldTopValueBar(fieldTopValuesBucketOverridableProps) : {};
  const {
    field,
    type,
    fieldValue,
    formattedFieldValue,
    formattedPercentage,
    progressValue,
    count,
    color,
    textProps = {}
  } = {
    ...fieldTopValuesBucketOverridableProps,
    ...overrides
  };
  const fieldLabel = (_multi$parent = field === null || field === void 0 ? void 0 : (_field$subType = field.subType) === null || _field$subType === void 0 ? void 0 : (_field$subType$multi = _field$subType.multi) === null || _field$subType$multi === void 0 ? void 0 : _field$subType$multi.parent) !== null && _multi$parent !== void 0 ? _multi$parent : field.name;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch",
    gutterSize: "s",
    responsive: false,
    "data-test-subj": `${dataTestSubject}-topValues-bucket`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: (0, _react2.css)`
          min-width: 0;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: "eui-textTruncate",
    "data-test-subj": `${dataTestSubject}-topValues-formattedFieldValue`
  }, ((_formattedFieldValue$ = formattedFieldValue === null || formattedFieldValue === void 0 ? void 0 : formattedFieldValue.length) !== null && _formattedFieldValue$ !== void 0 ? _formattedFieldValue$ : 0) > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: formattedFieldValue,
    delay: "long"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, (0, _extends2.default)({
    size: "xs",
    className: "eui-textTruncate",
    color: 'subdued'
  }, textProps), formattedFieldValue)) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, type === 'other' ? _i18n.i18n.translate('unifiedFieldList.fieldStats.otherDocsLabel', {
    defaultMessage: 'Other'
  }) : formattedFieldValue === '' ? _i18n.i18n.translate('unifiedFieldList.fieldStats.emptyStringValueLabel', {
    defaultMessage: '(empty)'
  }) : '-')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `${dataTestSubject}-topValues-formattedPercentage`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('unifiedFieldList.fieldStats.bucketPercentageTooltip', {
      defaultMessage: '{formattedPercentage} ({count, plural, one {# record} other {# records}})',
      values: {
        formattedPercentage,
        count
      }
    }),
    delay: "long"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "left",
    color: color
  }, formattedPercentage)))), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: progressValue,
    max: 1,
    size: "s",
    color: type === 'other' ? 'subdued' : color,
    "aria-label": `${formattedFieldValue} (${formattedPercentage})`
  })), onAddFilter && field.filterable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, type === 'other' ? /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                width: 48px;
              `
  }) : /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconSize: "s",
    iconType: "plusInCircle",
    onClick: () => onAddFilter(field, fieldValue, '+'),
    "aria-label": _i18n.i18n.translate('unifiedFieldList.fieldStats.filterValueButtonAriaLabel', {
      defaultMessage: 'Filter for {field}: "{value}"',
      values: {
        value: formattedFieldValue,
        field: fieldLabel
      }
    }),
    "data-test-subj": `plus-${fieldLabel}-${fieldValue}`,
    style: {
      minHeight: 'auto',
      minWidth: 'auto',
      paddingRight: 2,
      paddingLeft: 2,
      paddingTop: 0,
      paddingBottom: 0
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconSize: "s",
    iconType: "minusInCircle",
    onClick: () => onAddFilter(field, fieldValue, '-'),
    "aria-label": _i18n.i18n.translate('unifiedFieldList.fieldStats.filterOutValueButtonAriaLabel', {
      defaultMessage: 'Filter out {field}: "{value}"',
      values: {
        value: formattedFieldValue,
        field: fieldLabel
      }
    }),
    "data-test-subj": `minus-${fieldLabel}-${fieldValue}`,
    style: {
      minHeight: 'auto',
      minWidth: 'auto',
      paddingTop: 0,
      paddingBottom: 0,
      paddingRight: 2,
      paddingLeft: 2
    }
  }))));
};

// Necessary for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = FieldTopValuesBucket;
exports.default = _default;
module.exports = exports.default;