"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldPopoverHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldPopoverHeader = ({
  field,
  closePopover,
  buttonAddFieldToWorkspaceProps,
  buttonAddFilterProps,
  buttonEditFieldProps,
  buttonDeleteFieldProps,
  onAddFieldToWorkspace,
  onAddFilter,
  onEditField,
  onDeleteField
}) => {
  var _buttonAddFieldToWork, _buttonAddFilterProps, _buttonEditFieldProps, _buttonDeleteFieldPro;
  if (!field) {
    return null;
  }
  const addFieldToWorkspaceTooltip = _i18n.i18n.translate('unifiedFieldList.fieldPopover.addFieldToWorkspaceLabel', {
    defaultMessage: 'Add "{field}" field',
    values: {
      field: field.displayName
    }
  });
  const addExistsFilterTooltip = _i18n.i18n.translate('unifiedFieldList.fieldPopover.addExistsFilterLabel', {
    defaultMessage: 'Filter for field present'
  });
  const editFieldTooltip = _i18n.i18n.translate('unifiedFieldList.fieldPopover.editFieldLabel', {
    defaultMessage: 'Edit data view field'
  });
  const deleteFieldTooltip = _i18n.i18n.translate('unifiedFieldList.fieldPopover.deleteFieldLabel', {
    defaultMessage: 'Delete data view field'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    className: "eui-textBreakWord"
  }, field.displayName))), onAddFieldToWorkspace && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "fieldPopoverHeader_addField"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (_buttonAddFieldToWork = buttonAddFieldToWorkspaceProps === null || buttonAddFieldToWorkspaceProps === void 0 ? void 0 : buttonAddFieldToWorkspaceProps['aria-label']) !== null && _buttonAddFieldToWork !== void 0 ? _buttonAddFieldToWork : addFieldToWorkspaceTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": `fieldPopoverHeader_addField-${field.name}`,
    "aria-label": addFieldToWorkspaceTooltip
  }, buttonAddFieldToWorkspaceProps || {}, {
    iconType: "plusInCircle",
    onClick: () => {
      closePopover();
      onAddFieldToWorkspace(field);
    }
  })))), onAddFilter && field.filterable && !field.scripted && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "fieldPopoverHeader_addExistsFilter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (_buttonAddFilterProps = buttonAddFilterProps === null || buttonAddFilterProps === void 0 ? void 0 : buttonAddFilterProps['aria-label']) !== null && _buttonAddFilterProps !== void 0 ? _buttonAddFilterProps : addExistsFilterTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": `fieldPopoverHeader_addExistsFilter-${field.name}`,
    "aria-label": addExistsFilterTooltip
  }, buttonAddFilterProps || {}, {
    iconType: "filter",
    onClick: () => {
      closePopover();
      onAddFilter('_exists_', field.name, '+');
    }
  })))), onEditField && (field.isRuntimeField || !['unknown', 'unknown_selected'].includes(field.type)) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "fieldPopoverHeader_editField"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (_buttonEditFieldProps = buttonEditFieldProps === null || buttonEditFieldProps === void 0 ? void 0 : buttonEditFieldProps['aria-label']) !== null && _buttonEditFieldProps !== void 0 ? _buttonEditFieldProps : editFieldTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": `fieldPopoverHeader_editField-${field.name}`,
    "aria-label": editFieldTooltip
  }, buttonEditFieldProps || {}, {
    iconType: "pencil",
    onClick: () => {
      closePopover();
      onEditField(field.name);
    }
  })))), onDeleteField && field.isRuntimeField && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "fieldPopoverHeader_deleteField"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (_buttonDeleteFieldPro = buttonDeleteFieldProps === null || buttonDeleteFieldProps === void 0 ? void 0 : buttonDeleteFieldProps['aria-label']) !== null && _buttonDeleteFieldPro !== void 0 ? _buttonDeleteFieldPro : deleteFieldTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": `fieldPopoverHeader_deleteField-${field.name}`,
    "aria-label": deleteFieldTooltip
  }, buttonDeleteFieldProps || {}, {
    color: "danger",
    iconType: "trash",
    onClick: () => {
      closePopover();
      onDeleteField(field.name);
    }
  })))));
};
exports.FieldPopoverHeader = FieldPopoverHeader;