"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoFieldsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultNoFieldsMessageCopy = _i18n.i18n.translate('unifiedFieldList.fieldList.noFieldsCallout.noDataLabel', {
  defaultMessage: 'There are no fields.'
});
const NoFieldsCallout = ({
  fieldsExistInIndex,
  defaultNoFieldsMessage = defaultNoFieldsMessageCopy,
  isAffectedByFieldFilter = false,
  isAffectedByTimerange = false,
  isAffectedByGlobalFilter = false,
  'data-test-subj': dataTestSubject = 'noFieldsCallout'
}) => {
  if (!fieldsExistInIndex) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "warning",
      title: _i18n.i18n.translate('unifiedFieldList.fieldList.noFieldsCallout.noFieldsLabel', {
        defaultMessage: 'No fields exist in this data view.'
      }),
      "data-test-subj": `${dataTestSubject}-noFieldsExist`
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    title: isAffectedByFieldFilter ? _i18n.i18n.translate('unifiedFieldList.fieldList.noFieldsCallout.noFilteredFieldsLabel', {
      defaultMessage: 'No fields match the selected filters.'
    }) : defaultNoFieldsMessage,
    "data-test-subj": `${dataTestSubject}-noFieldsMatch`
  }, (isAffectedByTimerange || isAffectedByFieldFilter || isAffectedByGlobalFilter) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('unifiedFieldList.fieldList.noFieldsCallout.noFields.tryText', {
    defaultMessage: 'Try:'
  })), /*#__PURE__*/_react.default.createElement("ul", null, isAffectedByTimerange && /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('unifiedFieldList.fieldList.noFieldsCallout.noFields.extendTimeBullet', {
    defaultMessage: 'Extending the time range'
  })), isAffectedByFieldFilter && /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('unifiedFieldList.fieldList.noFieldsCallout.noFields.fieldTypeFilterBullet', {
    defaultMessage: 'Using different field filters'
  })), isAffectedByGlobalFilter && /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('unifiedFieldList.fieldList.noFieldsCallout.noFields.globalFiltersBullet', {
    defaultMessage: 'Changing the global filters'
  })))));
};
exports.NoFieldsCallout = NoFieldsCallout;