"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldKey = exports.FieldsAccordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
require("./fields_accordion.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function InnerFieldsAccordion({
  initialIsOpen,
  onToggle,
  id,
  label,
  helpTooltip,
  hasLoaded,
  fieldsCount,
  hideDetails,
  isFiltered,
  groupIndex,
  groupName,
  fieldSearchHighlight,
  paginatedFields,
  renderFieldItem,
  renderCallout,
  showExistenceFetchError,
  showExistenceFetchTimeout
}) {
  const renderButton = (0, _react.useMemo)(() => {
    const titleClassname = (0, _classnames.default)({
      // eslint-disable-next-line @typescript-eslint/naming-convention
      unifiedFieldList__fieldsAccordion__titleTooltip: !!helpTooltip
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("strong", {
      className: titleClassname
    }, label), !!helpTooltip && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      "aria-label": helpTooltip,
      type: "questionInCircle",
      color: "subdued",
      size: "s",
      position: "right",
      content: helpTooltip,
      iconProps: {
        className: 'eui-alignTop'
      }
    }));
  }, [label, helpTooltip]);
  const extraAction = (0, _react.useMemo)(() => {
    if (showExistenceFetchError) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        "aria-label": _i18n.i18n.translate('unifiedFieldList.fieldsAccordion.existenceErrorAriaLabel', {
          defaultMessage: 'Existence fetch failed'
        }),
        type: "warning",
        color: "warning",
        content: _i18n.i18n.translate('unifiedFieldList.fieldsAccordion.existenceErrorLabel', {
          defaultMessage: "Field information can't be loaded"
        }),
        iconProps: {
          'data-test-subj': `${id}-fetchWarning`
        }
      });
    }
    if (showExistenceFetchTimeout) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        "aria-label": _i18n.i18n.translate('unifiedFieldList.fieldsAccordion.existenceTimeoutAriaLabel', {
          defaultMessage: 'Existence fetch timed out'
        }),
        type: "clock",
        color: "warning",
        content: _i18n.i18n.translate('unifiedFieldList.fieldsAccordion.existenceTimeoutLabel', {
          defaultMessage: 'Field information took too long'
        })
      });
    }
    if (hasLoaded) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        size: "m",
        color: isFiltered ? 'accent' : 'subdued',
        "data-test-subj": `${id}-count`
      }, fieldsCount);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": `${id}-countLoading`
    });
  }, [showExistenceFetchError, showExistenceFetchTimeout, hasLoaded, isFiltered, id, fieldsCount]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: initialIsOpen,
    onToggle: onToggle,
    "data-test-subj": id,
    id: id,
    buttonContent: renderButton,
    extraAction: extraAction
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), hasLoaded && (!!fieldsCount ? /*#__PURE__*/_react.default.createElement("ul", {
    className: "unifiedFieldList__fieldsAccordion__fieldItems"
  }, paginatedFields && paginatedFields.map((field, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: getFieldKey(field)
  }, renderFieldItem({
    field,
    itemIndex: index,
    groupIndex,
    groupName,
    hideDetails,
    fieldSearchHighlight
  })))) : renderCallout()));
}
const FieldsAccordion = /*#__PURE__*/_react.default.memo(InnerFieldsAccordion);
exports.FieldsAccordion = FieldsAccordion;
const getFieldKey = field => `${field.name}-${field.displayName}-${field.type}`;
exports.getFieldKey = getFieldKey;