"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LOCAL_STORAGE_KEY_SECTIONS = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _no_fields_callout = require("./no_fields_callout");
var _fields_accordion = require("./fields_accordion");
var _types = require("../../types");
require("./field_list_grouped.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PAGINATION_SIZE = 50;
const LOCAL_STORAGE_KEY_SECTIONS = 'unifiedFieldList.initiallyOpenSections';
exports.LOCAL_STORAGE_KEY_SECTIONS = LOCAL_STORAGE_KEY_SECTIONS;
function getDisplayedFieldsLength(fieldGroups, accordionState) {
  return Object.entries(fieldGroups).filter(([key]) => accordionState[key]).reduce((allFieldCount, [, {
    fields
  }]) => allFieldCount + fields.length, 0);
}
function InnerFieldListGrouped({
  fieldGroups,
  fieldsExistenceStatus,
  fieldsExistInIndex,
  renderFieldItem,
  scrollToTopResetCounter,
  screenReaderDescriptionId,
  localStorageKeyPrefix,
  'data-test-subj': dataTestSubject = 'fieldListGrouped'
}) {
  var _fieldGroupsToCollaps, _fieldGroupsToCollaps2, _fieldGroupsToCollaps3, _fieldGroups$Selected, _fieldGroups$Selected2, _fieldGroups$PopularF, _fieldGroups$PopularF2, _fieldGroups$Availabl, _fieldGroups$Unmapped, _fieldGroups$Unmapped2, _fieldGroups$EmptyFie, _fieldGroups$EmptyFie2, _fieldGroups$MetaFiel, _fieldGroups$MetaFiel2;
  const hasSyncedExistingFields = fieldsExistenceStatus && fieldsExistenceStatus !== _types.ExistenceFetchStatus.unknown;
  const [fieldGroupsToShow, fieldGroupsToCollapse] = (0, _lodash.partition)(Object.entries(fieldGroups), ([, {
    showInAccordion
  }]) => showInAccordion);
  const [pageSize, setPageSize] = (0, _react.useState)(PAGINATION_SIZE);
  const [scrollContainer, setScrollContainer] = (0, _react.useState)(undefined);
  const [storedInitiallyOpenSections, storeInitiallyOpenSections] = (0, _useLocalStorage.default)(`${localStorageKeyPrefix ? localStorageKeyPrefix + '.' : ''}${LOCAL_STORAGE_KEY_SECTIONS}`, {});
  const [accordionState, setAccordionState] = (0, _react.useState)(() => Object.fromEntries(fieldGroupsToShow.map(([key, {
    isInitiallyOpen
  }]) => {
    const storedInitiallyOpen = localStorageKeyPrefix ? storedInitiallyOpenSections === null || storedInitiallyOpenSections === void 0 ? void 0 : storedInitiallyOpenSections[key] : null; // from localStorage
    return [key, typeof storedInitiallyOpen === 'boolean' ? storedInitiallyOpen : isInitiallyOpen];
  })));
  (0, _react.useEffect)(() => {
    // Reset the scroll if we have made material changes to the field list
    if (scrollContainer && scrollToTopResetCounter) {
      scrollContainer.scrollTop = 0;
      setPageSize(PAGINATION_SIZE);
    }
  }, [scrollToTopResetCounter, scrollContainer]);
  const lazyScroll = (0, _react.useCallback)(() => {
    if (scrollContainer) {
      const nearBottom = scrollContainer.scrollTop + scrollContainer.clientHeight > scrollContainer.scrollHeight * 0.9;
      if (nearBottom) {
        setPageSize(Math.max(PAGINATION_SIZE, Math.min(pageSize + PAGINATION_SIZE * 0.5, getDisplayedFieldsLength(fieldGroups, accordionState))));
      }
    }
  }, [scrollContainer, pageSize, setPageSize, fieldGroups, accordionState]);
  const paginatedFields = (0, _react.useMemo)(() => {
    let remainingItems = pageSize;
    return Object.fromEntries(fieldGroupsToShow.map(([key, fieldGroup]) => {
      if (!accordionState[key] || remainingItems <= 0) {
        return [key, []];
      }
      const slicedFieldList = fieldGroup.fields.slice(0, remainingItems);
      remainingItems = remainingItems - slicedFieldList.length;
      return [key, slicedFieldList];
    }));
  }, [pageSize, fieldGroupsToShow, accordionState]);
  const hasSpecialFields = Boolean((_fieldGroupsToCollaps = fieldGroupsToCollapse[0]) === null || _fieldGroupsToCollaps === void 0 ? void 0 : (_fieldGroupsToCollaps2 = _fieldGroupsToCollaps[1]) === null || _fieldGroupsToCollaps2 === void 0 ? void 0 : (_fieldGroupsToCollaps3 = _fieldGroupsToCollaps2.fields) === null || _fieldGroupsToCollaps3 === void 0 ? void 0 : _fieldGroupsToCollaps3.length);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "unifiedFieldList__fieldListGrouped",
    "data-test-subj": `${dataTestSubject}FieldGroups`,
    ref: el => {
      if (el && !el.dataset.dynamicScroll) {
        el.dataset.dynamicScroll = 'true';
        setScrollContainer(el);
      }
    },
    onScroll: (0, _lodash.throttle)(lazyScroll, 100)
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "unifiedFieldList__fieldListGrouped__container"
  }, Boolean(screenReaderDescriptionId) && /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("div", {
    "aria-live": "polite",
    id: screenReaderDescriptionId,
    "data-test-subj": `${dataTestSubject}__ariaDescription`
  }, hasSyncedExistingFields ? [shouldIncludeGroupDescriptionInAria(fieldGroups.SelectedFields) && _i18n.i18n.translate('unifiedFieldList.fieldListGrouped.fieldSearchForSelectedFieldsLiveRegion', {
    defaultMessage: '{selectedFields} selected {selectedFields, plural, one {field} other {fields}}.',
    values: {
      selectedFields: ((_fieldGroups$Selected = fieldGroups.SelectedFields) === null || _fieldGroups$Selected === void 0 ? void 0 : (_fieldGroups$Selected2 = _fieldGroups$Selected.fields) === null || _fieldGroups$Selected2 === void 0 ? void 0 : _fieldGroups$Selected2.length) || 0
    }
  }), shouldIncludeGroupDescriptionInAria(fieldGroups.PopularFields) && _i18n.i18n.translate('unifiedFieldList.fieldListGrouped.fieldSearchForPopularFieldsLiveRegion', {
    defaultMessage: '{popularFields} popular {popularFields, plural, one {field} other {fields}}.',
    values: {
      popularFields: ((_fieldGroups$PopularF = fieldGroups.PopularFields) === null || _fieldGroups$PopularF === void 0 ? void 0 : (_fieldGroups$PopularF2 = _fieldGroups$PopularF.fields) === null || _fieldGroups$PopularF2 === void 0 ? void 0 : _fieldGroups$PopularF2.length) || 0
    }
  }), ((_fieldGroups$Availabl = fieldGroups.AvailableFields) === null || _fieldGroups$Availabl === void 0 ? void 0 : _fieldGroups$Availabl.fields) && _i18n.i18n.translate('unifiedFieldList.fieldListGrouped.fieldSearchForAvailableFieldsLiveRegion', {
    defaultMessage: '{availableFields} available {availableFields, plural, one {field} other {fields}}.',
    values: {
      availableFields: fieldGroups.AvailableFields.fields.length
    }
  }), shouldIncludeGroupDescriptionInAria(fieldGroups.UnmappedFields) && _i18n.i18n.translate('unifiedFieldList.fieldListGrouped.fieldSearchForUnmappedFieldsLiveRegion', {
    defaultMessage: '{unmappedFields} unmapped {unmappedFields, plural, one {field} other {fields}}.',
    values: {
      unmappedFields: ((_fieldGroups$Unmapped = fieldGroups.UnmappedFields) === null || _fieldGroups$Unmapped === void 0 ? void 0 : (_fieldGroups$Unmapped2 = _fieldGroups$Unmapped.fields) === null || _fieldGroups$Unmapped2 === void 0 ? void 0 : _fieldGroups$Unmapped2.length) || 0
    }
  }), shouldIncludeGroupDescriptionInAria(fieldGroups.EmptyFields) && _i18n.i18n.translate('unifiedFieldList.fieldListGrouped.fieldSearchForEmptyFieldsLiveRegion', {
    defaultMessage: '{emptyFields} empty {emptyFields, plural, one {field} other {fields}}.',
    values: {
      emptyFields: ((_fieldGroups$EmptyFie = fieldGroups.EmptyFields) === null || _fieldGroups$EmptyFie === void 0 ? void 0 : (_fieldGroups$EmptyFie2 = _fieldGroups$EmptyFie.fields) === null || _fieldGroups$EmptyFie2 === void 0 ? void 0 : _fieldGroups$EmptyFie2.length) || 0
    }
  }), shouldIncludeGroupDescriptionInAria(fieldGroups.MetaFields) && _i18n.i18n.translate('unifiedFieldList.fieldListGrouped.fieldSearchForMetaFieldsLiveRegion', {
    defaultMessage: '{metaFields} meta {metaFields, plural, one {field} other {fields}}.',
    values: {
      metaFields: ((_fieldGroups$MetaFiel = fieldGroups.MetaFields) === null || _fieldGroups$MetaFiel === void 0 ? void 0 : (_fieldGroups$MetaFiel2 = _fieldGroups$MetaFiel.fields) === null || _fieldGroups$MetaFiel2 === void 0 ? void 0 : _fieldGroups$MetaFiel2.length) || 0
    }
  })].filter(Boolean).join(' ') : '')), hasSpecialFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("ul", null, fieldGroupsToCollapse.flatMap(([key, {
    fields,
    fieldSearchHighlight
  }]) => fields.map((field, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: (0, _fields_accordion.getFieldKey)(field)
  }, renderFieldItem({
    field,
    itemIndex: index,
    groupIndex: 0,
    groupName: key,
    hideDetails: true,
    fieldSearchHighlight
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), fieldGroupsToShow.map(([key, fieldGroup], index) => {
    const hidden = Boolean(fieldGroup.hideIfEmpty) && !fieldGroup.fields.length;
    if (hidden) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: key
    }, /*#__PURE__*/_react.default.createElement(_fields_accordion.FieldsAccordion, {
      id: `${dataTestSubject}${key}`,
      initialIsOpen: Boolean(accordionState[key]),
      label: fieldGroup.title,
      helpTooltip: fieldGroup.helpText,
      hideDetails: fieldGroup.hideDetails,
      hasLoaded: hasSyncedExistingFields,
      fieldsCount: fieldGroup.fields.length,
      isFiltered: fieldGroup.fieldCount !== fieldGroup.fields.length,
      fieldSearchHighlight: fieldGroup.fieldSearchHighlight,
      paginatedFields: paginatedFields[key],
      groupIndex: index + 1,
      groupName: key,
      onToggle: open => {
        setAccordionState(s => ({
          ...s,
          [key]: open
        }));
        const displayedFieldLength = getDisplayedFieldsLength(fieldGroups, {
          ...accordionState,
          [key]: open
        });
        setPageSize(Math.max(PAGINATION_SIZE, Math.min(Math.ceil(pageSize * 1.5), displayedFieldLength)));
        if (localStorageKeyPrefix) {
          storeInitiallyOpenSections({
            ...storedInitiallyOpenSections,
            [key]: open
          });
        }
      },
      showExistenceFetchError: fieldsExistenceStatus === _types.ExistenceFetchStatus.failed,
      showExistenceFetchTimeout: fieldsExistenceStatus === _types.ExistenceFetchStatus.failed // TODO: deprecate timeout logic?
      ,
      renderCallout: () => /*#__PURE__*/_react.default.createElement(_no_fields_callout.NoFieldsCallout, {
        isAffectedByGlobalFilter: fieldGroup.isAffectedByGlobalFilter,
        isAffectedByTimerange: fieldGroup.isAffectedByTimeFilter,
        isAffectedByFieldFilter: fieldGroup.fieldCount !== fieldGroup.fields.length,
        fieldsExistInIndex: !!fieldsExistInIndex,
        defaultNoFieldsMessage: fieldGroup.defaultNoFieldsMessage,
        "data-test-subj": `${dataTestSubject}${key}NoFieldsCallout`
      }),
      renderFieldItem: renderFieldItem
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  })));
}
const FieldListGrouped = /*#__PURE__*/_react.default.memo(InnerFieldListGrouped);

// Necessary for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = FieldListGrouped;
exports.default = _default;
function shouldIncludeGroupDescriptionInAria(group) {
  var _group$fields;
  if (!group) {
    return false;
  }
  // has some fields or an empty list should be still shown
  return ((_group$fields = group.fields) === null || _group$fields === void 0 ? void 0 : _group$fields.length) > 0 || !group.hideIfEmpty;
}