"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldNameSearch = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Search input for fields list
 * @param dataTestSubject
 * @param append
 * @param nameFilter
 * @param screenReaderDescriptionId
 * @param onChange
 * @constructor
 */
const FieldNameSearch = ({
  'data-test-subj': dataTestSubject,
  append,
  nameFilter,
  screenReaderDescriptionId,
  onChange
}) => {
  const searchPlaceholder = _i18n.i18n.translate('unifiedFieldList.fieldNameSearch.filterByNameLabel', {
    defaultMessage: 'Search field names',
    description: 'Search the list of fields in the data view for the provided text'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "aria-describedby": screenReaderDescriptionId,
    "aria-label": searchPlaceholder,
    "data-test-subj": `${dataTestSubject}FieldSearch`,
    fullWidth: true,
    onChange: event => onChange(event.target.value),
    placeholder: searchPlaceholder,
    value: nameFilter,
    append: append
  });
};
exports.FieldNameSearch = FieldNameSearch;