"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldItemButton = FieldItemButton;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _reactField = require("@kbn/react-field");
var _eui = require("@elastic/eui");
var _field_icon = require("../field_icon");
var _field_name_wildcard_matcher = require("../../utils/field_name_wildcard_matcher");
require("./field_item_button.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Field list item component
 * @param field
 * @param fieldSearchHighlight
 * @param isSelected
 * @param isActive
 * @param isEmpty
 * @param infoIcon
 * @param className
 * @param getCustomFieldType
 * @param dataTestSubj
 * @param size
 * @param onClick
 * @param shouldAlwaysShowAction
 * @param buttonAddFieldToWorkspaceProps
 * @param buttonRemoveFieldFromWorkspaceProps
 * @param onAddFieldToWorkspace
 * @param onRemoveFieldFromWorkspace
 * @param otherProps
 * @constructor
 */
function FieldItemButton({
  field,
  fieldSearchHighlight,
  isSelected,
  isActive,
  isEmpty,
  infoIcon,
  className,
  getCustomFieldType,
  dataTestSubj,
  size,
  onClick,
  shouldAlwaysShowAction,
  buttonAddFieldToWorkspaceProps,
  buttonRemoveFieldFromWorkspaceProps,
  onAddFieldToWorkspace,
  onRemoveFieldFromWorkspace,
  ...otherProps
}) {
  var _buttonAddFieldToWork, _buttonRemoveFieldFro;
  const displayName = field.displayName || field.name;
  const title = displayName !== field.name && field.name !== '___records___' ? _i18n.i18n.translate('unifiedFieldList.fieldItemButton.fieldTitle', {
    defaultMessage: '{fieldDisplayName} ({fieldName})',
    values: {
      fieldName: field.name,
      fieldDisplayName: displayName
    }
  }) : displayName;
  const iconProps = getCustomFieldType ? {
    type: getCustomFieldType(field)
  } : (0, _field_icon.getFieldIconProps)(field);
  const type = iconProps.type;
  const classes = (0, _classnames.default)('unifiedFieldListItemButton', {
    [`unifiedFieldListItemButton--${type}`]: type,
    [`unifiedFieldListItemButton--exists`]: !isEmpty,
    [`unifiedFieldListItemButton--missing`]: isEmpty
  }, className);
  const addFieldToWorkspaceTooltip = (_buttonAddFieldToWork = buttonAddFieldToWorkspaceProps === null || buttonAddFieldToWorkspaceProps === void 0 ? void 0 : buttonAddFieldToWorkspaceProps['aria-label']) !== null && _buttonAddFieldToWork !== void 0 ? _buttonAddFieldToWork : _i18n.i18n.translate('unifiedFieldList.fieldItemButton.addFieldToWorkspaceLabel', {
    defaultMessage: 'Add "{field}" field',
    values: {
      field: field.displayName
    }
  });
  const removeFieldFromWorkspaceTooltip = (_buttonRemoveFieldFro = buttonRemoveFieldFromWorkspaceProps === null || buttonRemoveFieldFromWorkspaceProps === void 0 ? void 0 : buttonRemoveFieldFromWorkspaceProps['aria-label']) !== null && _buttonRemoveFieldFro !== void 0 ? _buttonRemoveFieldFro : _i18n.i18n.translate('unifiedFieldList.fieldItemButton.removeFieldToWorkspaceLabel', {
    defaultMessage: 'Remove "{field}" field',
    values: {
      field: field.displayName
    }
  });
  const fieldActionClassName = (0, _classnames.default)('unifiedFieldListItemButton__action', {
    'unifiedFieldListItemButton__action--always': shouldAlwaysShowAction
  });
  const fieldAction = isSelected ? onRemoveFieldFromWorkspace && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    key: `selected-to-remove-${field.name}-${removeFieldFromWorkspaceTooltip}`,
    content: removeFieldFromWorkspaceTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": `unifiedFieldListItem_removeField-${field.name}`,
    "aria-label": removeFieldFromWorkspaceTooltip
  }, buttonRemoveFieldFromWorkspaceProps || {}, {
    className: (0, _classnames.default)(fieldActionClassName, buttonRemoveFieldFromWorkspaceProps === null || buttonRemoveFieldFromWorkspaceProps === void 0 ? void 0 : buttonRemoveFieldFromWorkspaceProps.className),
    color: "danger",
    iconType: "cross",
    onClick: event => {
      event.preventDefault();
      event.stopPropagation();
      onRemoveFieldFromWorkspace(field);
    }
  }))) : onAddFieldToWorkspace && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    key: `deselected-to-add-${field.name}-${addFieldToWorkspaceTooltip}`,
    content: addFieldToWorkspaceTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": `unifiedFieldListItem_addField-${field.name}`,
    "aria-label": addFieldToWorkspaceTooltip
  }, buttonAddFieldToWorkspaceProps || {}, {
    className: (0, _classnames.default)(fieldActionClassName, buttonAddFieldToWorkspaceProps === null || buttonAddFieldToWorkspaceProps === void 0 ? void 0 : buttonAddFieldToWorkspaceProps.className),
    color: "text",
    iconType: "plusInCircle",
    onClick: event => {
      event.preventDefault();
      event.stopPropagation();
      onAddFieldToWorkspace(field);
    }
  })));
  const conflictInfoIcon = field.type === 'conflict' ? /*#__PURE__*/_react.default.createElement(FieldConflictInfoIcon, null) : null;
  return /*#__PURE__*/_react.default.createElement(_reactField.FieldButton, (0, _extends2.default)({
    key: `field-item-button-${field.name}`,
    dataTestSubj: dataTestSubj,
    size: size || 's',
    className: classes,
    isActive: isActive,
    buttonProps: {
      ['aria-label']: _i18n.i18n.translate('unifiedFieldList.fieldItemButton.ariaLabel', {
        defaultMessage: 'Preview {fieldDisplayName}: {fieldType}',
        values: {
          fieldDisplayName: displayName,
          fieldType: getCustomFieldType ? getCustomFieldType(field) : field.type
        }
      })
    },
    fieldIcon: /*#__PURE__*/_react.default.createElement(_field_icon.FieldIcon, iconProps),
    fieldName: /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: getSearchHighlight(displayName, fieldSearchHighlight),
      title: title,
      "data-test-subj": `field-${field.name}`
    }, displayName),
    fieldAction: fieldAction,
    fieldInfoIcon: conflictInfoIcon || infoIcon,
    onClick: onClick
  }, otherProps));
}
function FieldConflictInfoIcon() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: _i18n.i18n.translate('unifiedFieldList.fieldItemButton.mappingConflictDescription', {
      defaultMessage: 'This field is defined as several types (string, integer, etc) across the indices that match this pattern.' + 'You may still be able to use this conflicting field, but it will be unavailable for functions that require Kibana to know their type. Correcting this issue will require reindexing your data.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    tabIndex: 0,
    type: "warning",
    title: _i18n.i18n.translate('unifiedFieldList.fieldItemButton.mappingConflictTitle', {
      defaultMessage: 'Mapping Conflict'
    }),
    size: "s"
  }));
}
function getSearchHighlight(displayName, fieldSearchHighlight) {
  const searchHighlight = fieldSearchHighlight || '';
  if (searchHighlight.includes('*') && (0, _field_name_wildcard_matcher.fieldNameWildcardMatcher)({
    name: displayName
  }, searchHighlight)) {
    return displayName;
  }
  return searchHighlight;
}