"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerContract = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This is a public representation of a trigger that is provided to other plugins.
 */
class TriggerContract {
  /**
   * Unique name of the trigger as identified in `ui_actions` plugin trigger registry.
   */

  /**
   * User friendly name of the trigger.
   */

  /**
   * A longer user friendly description of the trigger.
   */

  constructor(internal) {
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "description", void 0);
    /**
     * Use this method to execute action attached to this trigger.
     */
    (0, _defineProperty2.default)(this, "exec", async (context, alwaysShowPopup) => {
      await this.internal.execute(context, alwaysShowPopup);
    });
    this.internal = internal;
    this.id = this.internal.trigger.id;
    this.title = this.internal.trigger.title;
    this.description = this.internal.trigger.description;
  }
}
exports.TriggerContract = TriggerContract;