"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiActionsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _service = require("./service");
var _triggers = require("./triggers");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class UiActionsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "service", new _service.UiActionsService());
  }
  setup(core) {
    (0, _services.setTheme)(core.theme);
    this.service.registerTrigger(_triggers.rowClickTrigger);
    this.service.registerTrigger(_triggers.visualizeFieldTrigger);
    this.service.registerTrigger(_triggers.visualizeGeoFieldTrigger);
    this.service.registerTrigger(_triggers.categorizeFieldTrigger);
    return this.service;
  }
  start(core) {
    return this.service;
  }
  stop() {
    this.service.clear();
  }
}
exports.UiActionsPlugin = UiActionsPlugin;