"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionInternal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @internal
 */
class ActionInternal {
  constructor(definition) {
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "type", void 0);
    (0, _defineProperty2.default)(this, "order", void 0);
    (0, _defineProperty2.default)(this, "MenuItem", void 0);
    (0, _defineProperty2.default)(this, "grouping", void 0);
    (0, _defineProperty2.default)(this, "showNotification", void 0);
    (0, _defineProperty2.default)(this, "disabled", void 0);
    this.definition = definition;
    this.id = this.definition.id;
    this.type = this.definition.type || '';
    this.order = this.definition.order || 0;
    this.MenuItem = this.definition.MenuItem;
    this.grouping = this.definition.grouping;
    this.showNotification = this.definition.showNotification;
    this.disabled = this.definition.disabled;
  }
  execute(context) {
    return this.definition.execute(context);
  }
  getIconType(context) {
    if (!this.definition.getIconType) return undefined;
    return this.definition.getIconType(context);
  }
  getDisplayName(context) {
    if (!this.definition.getDisplayName) return `Action: ${this.id}`;
    return this.definition.getDisplayName(context);
  }
  getDisplayNameTooltip(context) {
    if (!this.definition.getDisplayNameTooltip) return '';
    return this.definition.getDisplayNameTooltip(context);
  }
  async isCompatible(context) {
    if (!this.definition.isCompatible) return true;
    return await this.definition.isCompatible(context);
  }
  async getHref(context) {
    if (!this.definition.getHref) return undefined;
    return await this.definition.getHref(context);
  }
  async shouldAutoExecute(context) {
    if (!this.definition.shouldAutoExecute) return false;
    return this.definition.shouldAutoExecute(context);
  }
}
exports.ActionInternal = ActionInternal;