"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiActionsServiceEnhancements = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
var _dynamic_actions = require("../dynamic_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class UiActionsServiceEnhancements {
  constructor({
    actionFactories = new Map(),
    ...deps
  }) {
    (0, _defineProperty2.default)(this, "actionFactories", void 0);
    (0, _defineProperty2.default)(this, "deps", void 0);
    /**
     * Register an action factory. Action factories are used to configure and
     * serialize/deserialize dynamic actions.
     */
    (0, _defineProperty2.default)(this, "registerActionFactory", definition => {
      if (this.actionFactories.has(definition.id)) {
        throw new Error(`ActionFactory [actionFactory.id = ${definition.id}] already registered.`);
      }
      const actionFactory = new _dynamic_actions.ActionFactory(definition, this.deps);
      this.actionFactories.set(actionFactory.id, actionFactory);
      this.registerFeatureUsage(definition);
    });
    (0, _defineProperty2.default)(this, "getActionFactory", actionFactoryId => {
      const actionFactory = this.actionFactories.get(actionFactoryId);
      if (!actionFactory) {
        throw new Error(`Action factory [actionFactoryId = ${actionFactoryId}] does not exist.`);
      }
      return actionFactory;
    });
    (0, _defineProperty2.default)(this, "hasActionFactory", actionFactoryId => {
      return this.actionFactories.has(actionFactoryId);
    });
    /**
     * Returns an array of all action factories.
     */
    (0, _defineProperty2.default)(this, "getActionFactories", () => {
      return [...this.actionFactories.values()];
    });
    /**
     * Convenience method to register a {@link DrilldownDefinition | drilldown}.
     */
    (0, _defineProperty2.default)(this, "registerDrilldown", ({
      id: factoryId,
      isBeta,
      order,
      CollectConfig,
      createConfig,
      isConfigValid,
      getDisplayName,
      actionMenuItem,
      euiIcon,
      execute,
      getHref,
      minimalLicense,
      licenseFeatureName,
      supportedTriggers,
      isCompatible,
      isConfigurable,
      telemetry,
      extract,
      inject
    }) => {
      const actionFactory = {
        id: factoryId,
        isBeta,
        minimalLicense,
        licenseFeatureName,
        order,
        CollectConfig,
        createConfig,
        isConfigValid,
        getDisplayName,
        supportedTriggers,
        telemetry,
        extract,
        inject,
        getIconType: () => euiIcon,
        isCompatible: async context => !isConfigurable || isConfigurable(context),
        create: serializedAction => ({
          id: '',
          type: factoryId,
          getIconType: () => euiIcon,
          getDisplayName: () => serializedAction.name,
          MenuItem: actionMenuItem ? ({
            context
          }) => /*#__PURE__*/(0, _react.createElement)(actionMenuItem, {
            context,
            config: serializedAction
          }) : undefined,
          execute: async context => await execute(serializedAction.config, context),
          getHref: getHref ? async context => getHref(serializedAction.config, context) : undefined,
          isCompatible: isCompatible ? async context => isCompatible(serializedAction.config, context) : undefined
        })
      };
      this.registerActionFactory(actionFactory);
    });
    (0, _defineProperty2.default)(this, "registerFeatureUsage", definition => {
      if (!definition.minimalLicense || !definition.licenseFeatureName) return;
      if (this.deps.featureUsageSetup) {
        this.deps.featureUsageSetup.register(definition.licenseFeatureName, definition.minimalLicense);
      }
    });
    (0, _defineProperty2.default)(this, "telemetry", (state, telemetry = {}) => {
      let telemetryData = telemetry;
      state.events.forEach(event => {
        if (this.actionFactories.has(event.action.factoryId)) {
          telemetryData = this.actionFactories.get(event.action.factoryId).telemetry(event, telemetryData);
        }
      });
      return telemetryData;
    });
    (0, _defineProperty2.default)(this, "extract", state => {
      const references = [];
      const newState = {
        events: state.events.map(event => {
          const result = this.actionFactories.has(event.action.factoryId) ? this.actionFactories.get(event.action.factoryId).extract(event) : {
            state: event,
            references: []
          };
          references.push(...result.references);
          return result.state;
        })
      };
      return {
        state: newState,
        references
      };
    });
    (0, _defineProperty2.default)(this, "inject", (state, references) => {
      return {
        events: state.events.map(event => {
          return this.actionFactories.has(event.action.factoryId) ? this.actionFactories.get(event.action.factoryId).inject(event, references) : event;
        })
      };
    });
    this.actionFactories = actionFactories;
    this.deps = deps;
  }
}
exports.UiActionsServiceEnhancements = UiActionsServiceEnhancements;