"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtUrlTemplateSyntaxHelpLinkText = exports.txtUrlTemplatePreviewLinkText = exports.txtUrlTemplatePreviewLabel = exports.txtUrlTemplatePlaceholder = exports.txtUrlTemplateOpenInNewTab = exports.txtUrlTemplateLabel = exports.txtUrlTemplateEncodeUrl = exports.txtUrlTemplateEncodeDescription = exports.txtUrlTemplateAdditionalOptions = exports.txtUrlPreviewHelpText = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const txtUrlTemplatePlaceholder = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlTemplatePlaceholderText', {
  defaultMessage: 'Example: {exampleUrl}',
  values: {
    exampleUrl: 'https://www.my-url.com/?{{event.key}}={{event.value}}'
  }
});
exports.txtUrlTemplatePlaceholder = txtUrlTemplatePlaceholder;
const txtUrlPreviewHelpText = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlPreviewHelpText', {
  defaultMessage: 'Please note that in preview \\{\\{event.*\\}\\} variables are substituted with dummy values.'
});
exports.txtUrlPreviewHelpText = txtUrlPreviewHelpText;
const txtUrlTemplateLabel = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlTemplateLabel', {
  defaultMessage: 'Enter URL'
});
exports.txtUrlTemplateLabel = txtUrlTemplateLabel;
const txtUrlTemplateSyntaxHelpLinkText = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlTemplateSyntaxHelpLinkText', {
  defaultMessage: 'Syntax help'
});
exports.txtUrlTemplateSyntaxHelpLinkText = txtUrlTemplateSyntaxHelpLinkText;
const txtUrlTemplatePreviewLabel = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlPreviewLabel', {
  defaultMessage: 'URL preview:'
});
exports.txtUrlTemplatePreviewLabel = txtUrlTemplatePreviewLabel;
const txtUrlTemplatePreviewLinkText = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.urlPreviewLinkText', {
  defaultMessage: 'Preview'
});
exports.txtUrlTemplatePreviewLinkText = txtUrlTemplatePreviewLinkText;
const txtUrlTemplateOpenInNewTab = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.openInNewTabLabel', {
  defaultMessage: 'Open in new window'
});
exports.txtUrlTemplateOpenInNewTab = txtUrlTemplateOpenInNewTab;
const txtUrlTemplateAdditionalOptions = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.additionalOptions', {
  defaultMessage: 'Additional options'
});
exports.txtUrlTemplateAdditionalOptions = txtUrlTemplateAdditionalOptions;
const txtUrlTemplateEncodeUrl = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.encodeUrl', {
  defaultMessage: 'Encode URL'
});
exports.txtUrlTemplateEncodeUrl = txtUrlTemplateEncodeUrl;
const txtUrlTemplateEncodeDescription = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.urlDrilldownCollectConfig.encodeDescription', {
  defaultMessage: 'If enabled, URL will be escaped using percent encoding'
});
exports.txtUrlTemplateEncodeDescription = txtUrlTemplateEncodeDescription;