"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtManage = exports.txtCreateNew = exports.Tabs = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _context = require("../context");
var _form_drilldown_wizard = require("../form_drilldown_wizard");
var _drilldown_list = require("../drilldown_list");
var _template_picker = require("../template_picker");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const txtCreateNew = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.containers.DrilldownManager.createNew', {
  defaultMessage: 'Create new'
});
exports.txtCreateNew = txtCreateNew;
const txtManage = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.containers.DrilldownManager.manage', {
  defaultMessage: 'Manage'
});
exports.txtManage = txtManage;
const tabs = [{
  id: 'create',
  name: txtCreateNew,
  content: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_eui.EuiSpacer, null), /*#__PURE__*/React.createElement(_form_drilldown_wizard.FormDrilldownWizard, null), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
    size: 'l'
  }), /*#__PURE__*/React.createElement(_template_picker.TemplatePicker, null))
}, {
  id: 'manage',
  name: txtManage,
  content: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_eui.EuiSpacer, null), /*#__PURE__*/React.createElement(_drilldown_list.DrilldownList, null))
}];
const Tabs = ({}) => {
  const drilldowns = (0, _context.useDrilldownManager)();
  const route = drilldowns.useRoute();
  return /*#__PURE__*/React.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    selectedTab: tabs.find(({
      id
    }) => id === route[0]),
    onTabClick: ({
      id
    }) => drilldowns.setRoute([id])
  });
};
exports.Tabs = Tabs;