"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPublicDrilldownManager = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const LazyDrilldownManager = /*#__PURE__*/React.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./drilldown_manager_with_provider'))).then(m => ({
  default: m.DrilldownManagerWithProvider
})));

/**
 * This HOC creates a "public" `<DrilldownManager>` component `PublicDrilldownManagerComponent`,
 * which can be exported from plugin contract for other plugins to consume.
 */
const createPublicDrilldownManager = dependencies => {
  const PublicDrilldownManager = drilldownManagerProps => {
    const filteredActionFactories = dependencies.actionFactories.filter(factory => {
      const supportedTriggers = factory.supportedTriggers();
      for (const supportedTrigger of supportedTriggers) {
        const supportsAtLeastOneTrigger = drilldownManagerProps.triggers.includes(supportedTrigger);
        if (supportsAtLeastOneTrigger) return true;
      }
      return false;
    });
    return /*#__PURE__*/React.createElement(React.Suspense, {
      fallback: null
    }, /*#__PURE__*/React.createElement(LazyDrilldownManager, (0, _extends2.default)({}, dependencies, drilldownManagerProps, {
      actionFactories: filteredActionFactories
    })));
  };
  return PublicDrilldownManager;
};
exports.createPublicDrilldownManager = createPublicDrilldownManager;