"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloningNotification = void 0;
var _eui = require("@elastic/eui");
var React = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const txtDismiss = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.containers.drilldownList.copyingNotification.dismiss', {
  defaultMessage: 'Dismiss',
  description: 'Dismiss button in cloning notification callout.'
});
const txtBody = count => _i18n.i18n.translate('uiActionsEnhanced.drilldowns.containers.drilldownList.copyingNotification.body', {
  defaultMessage: '{count, number} {count, plural, one {drilldown} other {drilldowns}} copied.',
  description: 'Title of notification show when one or more drilldowns were copied.',
  values: {
    count
  }
});
const CloningNotification = ({
  count = 1
}) => {
  const [dismissed, setDismissed] = React.useState(false);
  if (dismissed) return null;
  const title = /*#__PURE__*/React.createElement(React.Fragment, null, txtBody(count), " ", /*#__PURE__*/React.createElement(_eui.EuiLink, {
    onClick: () => setDismissed(true)
  }, txtDismiss));
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
    title: title,
    color: "success",
    size: "s",
    iconType: "check"
  }), /*#__PURE__*/React.createElement(_eui.EuiSpacer, null));
};
exports.CloningNotification = CloningNotification;