"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _trigger_picker_item = require("./trigger_picker_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const txtTriggerPickerLabel = _i18n.i18n.translate('uiActionsEnhanced.components.actionWizard.triggerPickerLabel', {
  defaultMessage: 'Show option on:'
});
const txtTriggerPickerHelpText = _i18n.i18n.translate('uiActionsEnhanced.components.actionWizard.triggerPickerHelpText', {
  defaultMessage: "What's this?"
});
const txtTriggerPickerHelpTooltip = _i18n.i18n.translate('uiActionsEnhanced.components.actionWizard.triggerPickerHelpTooltip', {
  defaultMessage: 'Determines when the drilldown appears in context menu'
});
const TriggerPicker = ({
  items,
  selected = [],
  docs,
  disabled,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    "data-test-subj": `triggerPicker`,
    legend: {
      children: !!docs && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement("span", null, txtTriggerPickerLabel), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: txtTriggerPickerHelpTooltip
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docs,
        target: 'blank',
        external: true
      }, txtTriggerPickerHelpText))))
    },
    style: {
      maxWidth: `80%`
    }
  }, items.map(trigger => /*#__PURE__*/_react.default.createElement(_trigger_picker_item.TriggerPickerItem, {
    key: trigger.id,
    id: trigger.id,
    title: trigger.title,
    description: trigger.description,
    checked: trigger.id === selected[0],
    disabled: disabled,
    onSelect: id => onChange([id])
  })));
};
exports.TriggerPicker = TriggerPicker;