"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrilldownTemplateTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
var _text_with_icon = require("../text_with_icon");
var _trigger_line_item = require("../trigger_line_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DrilldownTemplateTable = ({
  items,
  onCreate,
  onClone
}) => {
  const [selected, setSelected] = (0, _react.useState)([]);
  const columns = [{
    field: 'name',
    name: _i18n.txtNameColumnTitle,
    sortable: true,
    render: (omit, item) => /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: 'block'
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: 'block'
      }
    }, item.name), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs',
      color: 'subdued'
    }, item.description))
  }, {
    name: _i18n.txtActionColumnTitle,
    render: item => /*#__PURE__*/_react.default.createElement(_text_with_icon.TextWithIcon, {
      icon: item.actionIcon || 'empty',
      color: 'subdued'
    }, item.actionName)
  }, {
    field: 'trigger',
    name: _i18n.txtTriggerColumnTitle,
    sortable: true,
    render: (omit, item) => /*#__PURE__*/_react.default.createElement(_trigger_line_item.TriggerLineItem, {
      incompatible: item.triggerIncompatible
    }, item.trigger)
  }, {
    align: 'right',
    render: drilldown => !!onCreate && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      disabled: !!selected.length,
      onClick: () => onCreate(drilldown.id)
    }, _i18n.txtSingleItemCopyActionLabel)
  }];
  const search = {
    box: {
      incremental: true
    },
    defaultQuery: ''
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: "id",
    tableLayout: 'auto',
    items: items,
    columns: columns,
    isSelectable: !!onClone,
    responsive: false,
    search: search,
    sorting: {
      sort: {
        field: 'nameCol',
        direction: 'asc'
      }
    },
    selection: {
      onSelectionChange: selection => {
        setSelected(selection.map(drilldown => drilldown.id));
      },
      selectableMessage: () => _i18n.txtSelectableMessage
    },
    hasActions: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !!onClone && !!selected.length && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: () => onClone(selected)
  }, (0, _i18n.txtCopyButtonLabel)(selected.length)));
};
exports.DrilldownTemplateTable = DrilldownTemplateTable;